/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.annotation;

import cn.taketoday.aop.TargetSource;
import cn.taketoday.aop.framework.ProxyFactory;
import cn.taketoday.beans.factory.BeanFactory;
import cn.taketoday.beans.factory.NoSuchBeanDefinitionException;
import cn.taketoday.beans.factory.annotation.QualifierAnnotationAutowireCandidateResolver;
import cn.taketoday.beans.factory.config.DependencyDescriptor;
import cn.taketoday.beans.factory.support.StandardBeanFactory;
import cn.taketoday.context.annotation.Lazy;
import cn.taketoday.core.MethodParameter;
import cn.taketoday.core.annotation.AnnotationUtils;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ContextAnnotationAutowireCandidateResolver
extends QualifierAnnotationAutowireCandidateResolver {
    @Nullable
    public Object getLazyResolutionProxyIfNecessary(DependencyDescriptor descriptor, @Nullable String beanName) {
        return this.isLazy(descriptor) ? this.buildLazyResolutionProxy(descriptor, beanName) : null;
    }

    protected boolean isLazy(DependencyDescriptor descriptor) {
        Method method;
        for (Annotation ann : descriptor.getAnnotations()) {
            Lazy lazy = (Lazy)AnnotationUtils.getAnnotation((Annotation)ann, Lazy.class);
            if (lazy == null || !lazy.value()) continue;
            return true;
        }
        MethodParameter methodParam = descriptor.getMethodParameter();
        if (methodParam != null && ((method = methodParam.getMethod()) == null || Void.TYPE == method.getReturnType())) {
            Lazy lazy = (Lazy)AnnotationUtils.getAnnotation((AnnotatedElement)methodParam.getAnnotatedElement(), Lazy.class);
            return lazy != null && lazy.value();
        }
        return false;
    }

    protected Object buildLazyResolutionProxy(final DependencyDescriptor descriptor, final @Nullable String beanName) {
        BeanFactory beanFactory = this.getBeanFactory();
        Assert.state((boolean)(beanFactory instanceof StandardBeanFactory), (String)"BeanFactory needs to be a StandardBeanFactory");
        final StandardBeanFactory dlbf = (StandardBeanFactory)beanFactory;
        TargetSource ts = new TargetSource(){

            public Class<?> getTargetClass() {
                return descriptor.getDependencyType();
            }

            public boolean isStatic() {
                return false;
            }

            public Object getTarget() {
                LinkedHashSet autowiredBeanNames = beanName != null ? new LinkedHashSet(1) : null;
                Object target = dlbf.doResolveDependency(descriptor, beanName, autowiredBeanNames, null);
                if (target == null) {
                    Class<?> type = this.getTargetClass();
                    if (Map.class == type) {
                        return Collections.emptyMap();
                    }
                    if (List.class == type) {
                        return Collections.emptyList();
                    }
                    if (Set.class == type || Collection.class == type) {
                        return Collections.emptySet();
                    }
                    throw new NoSuchBeanDefinitionException(descriptor.getResolvableType(), "Optional dependency not present for lazy injection point");
                }
                if (autowiredBeanNames != null) {
                    for (String autowiredBeanName : autowiredBeanNames) {
                        if (!dlbf.containsBean(autowiredBeanName)) continue;
                        dlbf.registerDependentBean(autowiredBeanName, beanName);
                    }
                }
                return target;
            }

            public void releaseTarget(Object target) {
            }
        };
        ProxyFactory pf = new ProxyFactory();
        pf.setTargetSource(ts);
        Class dependencyType = descriptor.getDependencyType();
        if (dependencyType.isInterface()) {
            pf.addInterface(dependencyType);
        }
        return pf.getProxy(dlbf.getBeanClassLoader());
    }
}

