/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.annotation;

import cn.taketoday.aop.AopInfrastructureBean;
import cn.taketoday.beans.factory.annotation.AnnotatedBeanDefinition;
import cn.taketoday.beans.factory.config.BeanDefinition;
import cn.taketoday.beans.factory.config.BeanFactoryPostProcessor;
import cn.taketoday.beans.factory.config.BeanPostProcessor;
import cn.taketoday.beans.factory.support.AbstractBeanDefinition;
import cn.taketoday.context.annotation.ComponentScan;
import cn.taketoday.context.annotation.Configuration;
import cn.taketoday.context.annotation.ConfigurationClassPostProcessor;
import cn.taketoday.context.annotation.Import;
import cn.taketoday.context.annotation.ImportResource;
import cn.taketoday.context.event.EventListenerFactory;
import cn.taketoday.core.Conventions;
import cn.taketoday.core.annotation.MergedAnnotation;
import cn.taketoday.core.annotation.Order;
import cn.taketoday.core.type.AnnotationMetadata;
import cn.taketoday.core.type.classreading.MetadataReader;
import cn.taketoday.core.type.classreading.MetadataReaderFactory;
import cn.taketoday.lang.Nullable;
import cn.taketoday.logging.Logger;
import cn.taketoday.logging.LoggerFactory;
import cn.taketoday.stereotype.Component;
import java.io.IOException;
import java.util.Set;

abstract class ConfigurationClassUtils {
    public static final String CONFIGURATION_CLASS_FULL = "full";
    public static final String CONFIGURATION_CLASS_LITE = "lite";
    public static final String CONFIGURATION_CLASS_ATTRIBUTE = Conventions.getQualifiedAttributeName(ConfigurationClassPostProcessor.class, (String)"configurationClass");
    private static final String ORDER_ATTRIBUTE = Conventions.getQualifiedAttributeName(ConfigurationClassPostProcessor.class, (String)"order");
    private static final Logger log = LoggerFactory.getLogger(ConfigurationClassUtils.class);
    private static final Set<String> candidateIndicators = Set.of(Import.class.getName(), Component.class.getName(), ComponentScan.class.getName(), ImportResource.class.getName());

    ConfigurationClassUtils() {
    }

    public static boolean checkConfigurationClassCandidate(BeanDefinition beanDef, MetadataReaderFactory metadataReaderFactory) {
        AbstractBeanDefinition abd;
        AnnotationMetadata metadata;
        AnnotatedBeanDefinition annotated;
        String className = beanDef.getBeanClassName();
        if (className == null || beanDef.getFactoryMethodName() != null) {
            return false;
        }
        if (beanDef instanceof AnnotatedBeanDefinition && className.equals((annotated = (AnnotatedBeanDefinition)beanDef).getMetadata().getClassName())) {
            metadata = annotated.getMetadata();
        } else if (beanDef instanceof AbstractBeanDefinition && (abd = (AbstractBeanDefinition)beanDef).hasBeanClass()) {
            Class beanClass = abd.getBeanClass();
            if (BeanFactoryPostProcessor.class.isAssignableFrom(beanClass) || BeanPostProcessor.class.isAssignableFrom(beanClass) || AopInfrastructureBean.class.isAssignableFrom(beanClass) || EventListenerFactory.class.isAssignableFrom(beanClass)) {
                return false;
            }
            metadata = AnnotationMetadata.introspect((Class)beanClass);
        } else {
            try {
                MetadataReader metadataReader = metadataReaderFactory.getMetadataReader(className);
                metadata = metadataReader.getAnnotationMetadata();
            }
            catch (IOException ex) {
                if (log.isDebugEnabled()) {
                    log.debug("Could not find class file for introspecting configuration annotations: {}", (Object)className, (Object)ex);
                }
                return false;
            }
        }
        MergedAnnotation config = metadata.getAnnotation(Configuration.class);
        if (config.isPresent() && !Boolean.FALSE.equals(config.getBoolean("proxyBeanMethods"))) {
            beanDef.setAttribute(CONFIGURATION_CLASS_ATTRIBUTE, (Object)CONFIGURATION_CLASS_FULL);
        } else if (ConfigurationClassUtils.isConfigurationCandidate(metadata)) {
            beanDef.setAttribute(CONFIGURATION_CLASS_ATTRIBUTE, (Object)CONFIGURATION_CLASS_LITE);
        } else {
            return false;
        }
        Integer order = ConfigurationClassUtils.getOrder(metadata);
        if (order != null) {
            beanDef.setAttribute(ORDER_ATTRIBUTE, (Object)order);
        }
        return true;
    }

    public static boolean isConfigurationCandidate(AnnotationMetadata metadata) {
        if (metadata.isInterface()) {
            return false;
        }
        for (String indicator : candidateIndicators) {
            if (!metadata.isAnnotated(indicator)) continue;
            return true;
        }
        return ConfigurationClassUtils.hasComponentMethods(metadata);
    }

    static boolean hasComponentMethods(AnnotationMetadata metadata) {
        try {
            return metadata.hasAnnotatedMethods(Component.class.getName());
        }
        catch (Throwable ex) {
            log.debug("Failed to introspect @Component methods on class [{}]: {}", (Object)metadata.getClassName(), (Object)ex.toString());
            return false;
        }
    }

    @Nullable
    public static Integer getOrder(AnnotationMetadata metadata) {
        MergedAnnotation orderAnnotation = metadata.getAnnotation(Order.class);
        return orderAnnotation.isPresent() ? Integer.valueOf(orderAnnotation.getIntValue()) : null;
    }

    public static int getOrder(BeanDefinition beanDef) {
        Object order = beanDef.getAttribute(ORDER_ATTRIBUTE);
        if (order instanceof Integer) {
            return (Integer)order;
        }
        return Integer.MAX_VALUE;
    }
}

