/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.annotation;

import cn.taketoday.aop.framework.autoproxy.AutoProxyUtils;
import cn.taketoday.beans.PropertyValues;
import cn.taketoday.beans.factory.BeanClassLoaderAware;
import cn.taketoday.beans.factory.BeanDefinitionStoreException;
import cn.taketoday.beans.factory.BeanFactory;
import cn.taketoday.beans.factory.DependenciesBeanPostProcessor;
import cn.taketoday.beans.factory.InitializationBeanPostProcessor;
import cn.taketoday.beans.factory.annotation.AnnotatedBeanDefinition;
import cn.taketoday.beans.factory.config.BeanDefinition;
import cn.taketoday.beans.factory.config.BeanDefinitionHolder;
import cn.taketoday.beans.factory.config.BeanPostProcessor;
import cn.taketoday.beans.factory.config.ConfigurableBeanFactory;
import cn.taketoday.beans.factory.config.SingletonBeanRegistry;
import cn.taketoday.beans.factory.parsing.ProblemReporter;
import cn.taketoday.beans.factory.support.AbstractBeanDefinition;
import cn.taketoday.beans.factory.support.BeanDefinitionRegistry;
import cn.taketoday.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import cn.taketoday.beans.factory.support.BeanNameGenerator;
import cn.taketoday.context.BootstrapContext;
import cn.taketoday.context.BootstrapContextAware;
import cn.taketoday.context.annotation.AnnotationBeanNameGenerator;
import cn.taketoday.context.annotation.ConfigurationClass;
import cn.taketoday.context.annotation.ConfigurationClassBeanDefinitionReader;
import cn.taketoday.context.annotation.ConfigurationClassEnhancer;
import cn.taketoday.context.annotation.ConfigurationClassParser;
import cn.taketoday.context.annotation.ConfigurationClassUtils;
import cn.taketoday.context.annotation.FullyQualifiedAnnotationBeanNameGenerator;
import cn.taketoday.context.annotation.ImportAware;
import cn.taketoday.context.annotation.ImportRegistry;
import cn.taketoday.core.Ordered;
import cn.taketoday.core.PriorityOrdered;
import cn.taketoday.core.type.AnnotationMetadata;
import cn.taketoday.core.type.MethodMetadata;
import cn.taketoday.core.type.classreading.MetadataReaderFactory;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.logging.Logger;
import cn.taketoday.logging.LoggerFactory;
import cn.taketoday.util.ClassUtils;
import cn.taketoday.util.CollectionUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class ConfigurationClassPostProcessor
implements BeanDefinitionRegistryPostProcessor,
PriorityOrdered,
BeanClassLoaderAware,
BootstrapContextAware {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationClassPostProcessor.class);
    private static final String IMPORT_REGISTRY_BEAN_NAME = ConfigurationClassPostProcessor.class.getName() + ".importRegistry";
    public static final AnnotationBeanNameGenerator IMPORT_BEAN_NAME_GENERATOR = FullyQualifiedAnnotationBeanNameGenerator.INSTANCE;
    @Nullable
    private BootstrapContext bootstrapContext;
    private final Set<Integer> registriesPostProcessed = new HashSet<Integer>();
    private final Set<Integer> factoriesPostProcessed = new HashSet<Integer>();
    @Nullable
    private ConfigurationClassBeanDefinitionReader reader;
    private boolean localBeanNameGeneratorSet = false;
    private BeanNameGenerator importBeanNameGenerator = IMPORT_BEAN_NAME_GENERATOR;
    private ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();

    public ConfigurationClassPostProcessor() {
    }

    public ConfigurationClassPostProcessor(BootstrapContext bootstrapContext) {
        this.setBootstrapContext(bootstrapContext);
    }

    @Override
    public void setBootstrapContext(BootstrapContext context) {
        Assert.notNull((Object)((Object)context), (String)"BootstrapContext is required");
        this.bootstrapContext = context;
    }

    protected final BootstrapContext obtainBootstrapContext() {
        Assert.state((this.bootstrapContext != null ? 1 : 0) != 0, (String)"BootstrapContext is required");
        return this.bootstrapContext;
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public void setProblemReporter(@Nullable ProblemReporter problemReporter) {
        this.obtainBootstrapContext().setProblemReporter(problemReporter);
    }

    public void setBeanNameGenerator(BeanNameGenerator beanNameGenerator) {
        Assert.notNull((Object)beanNameGenerator, (String)"BeanNameGenerator must not be null");
        this.localBeanNameGeneratorSet = true;
        this.obtainBootstrapContext().setBeanNameGenerator(beanNameGenerator);
        this.importBeanNameGenerator = beanNameGenerator;
    }

    public void setBeanClassLoader(ClassLoader beanClassLoader) {
        this.beanClassLoader = beanClassLoader;
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) {
        int registryId = System.identityHashCode(registry);
        if (this.registriesPostProcessed.contains(registryId)) {
            throw new IllegalStateException("postProcessBeanDefinitionRegistry already called on this post-processor against " + registry);
        }
        if (this.factoriesPostProcessed.contains(registryId)) {
            throw new IllegalStateException("postProcessBeanFactory already called on this post-processor against " + registry);
        }
        this.registriesPostProcessed.add(registryId);
        this.processConfigBeanDefinitions(registry);
    }

    public void postProcessBeanFactory(ConfigurableBeanFactory beanFactory) {
        int factoryId;
        if (this.bootstrapContext == null) {
            this.bootstrapContext = BootstrapContext.from((BeanFactory)beanFactory);
        }
        if (this.factoriesPostProcessed.contains(factoryId = System.identityHashCode(beanFactory))) {
            throw new IllegalStateException("postProcessBeanFactory already called on this post-processor against " + beanFactory);
        }
        this.factoriesPostProcessed.add(factoryId);
        if (!this.registriesPostProcessed.contains(factoryId)) {
            this.processConfigBeanDefinitions((BeanDefinitionRegistry)beanFactory);
        }
        this.enhanceConfigurationClasses(beanFactory);
        beanFactory.addBeanPostProcessor((BeanPostProcessor)new ImportAwareBeanPostProcessor((BeanFactory)beanFactory));
    }

    public void processConfigBeanDefinitions(BeanDefinitionRegistry registry) {
        ArrayList<BeanDefinitionHolder> configCandidates = new ArrayList<BeanDefinitionHolder>();
        Object[] candidateNames = registry.getBeanDefinitionNames();
        BootstrapContext bootstrapContext = this.obtainBootstrapContext();
        MetadataReaderFactory metadataReaderFactory = bootstrapContext.getMetadataReaderFactory();
        for (String string : candidateNames) {
            BeanDefinition beanDef = registry.getBeanDefinition(string);
            if (beanDef.getAttribute(ConfigurationClassUtils.CONFIGURATION_CLASS_ATTRIBUTE) != null) {
                if (!log.isDebugEnabled()) continue;
                log.debug("Bean definition has already been processed as a configuration class: {}", (Object)beanDef);
                continue;
            }
            if (!ConfigurationClassUtils.checkConfigurationClassCandidate(beanDef, metadataReaderFactory)) continue;
            configCandidates.add(new BeanDefinitionHolder(beanDef, string));
        }
        if (configCandidates.isEmpty()) {
            return;
        }
        configCandidates.sort((bd1, bd2) -> {
            int i1 = ConfigurationClassUtils.getOrder(bd1.getBeanDefinition());
            int i2 = ConfigurationClassUtils.getOrder(bd2.getBeanDefinition());
            return Integer.compare(i1, i2);
        });
        SingletonBeanRegistry sbr = null;
        if (registry instanceof SingletonBeanRegistry) {
            BeanNameGenerator populator;
            sbr = (SingletonBeanRegistry)registry;
            if (!this.localBeanNameGeneratorSet && (populator = (BeanNameGenerator)sbr.getSingleton("cn.taketoday.context.annotation.internalConfigurationBeanNameGenerator")) != null) {
                this.importBeanNameGenerator = populator;
            }
        }
        ConfigurationClassParser parser = new ConfigurationClassParser(bootstrapContext);
        LinkedHashSet<BeanDefinitionHolder> candidates = new LinkedHashSet<BeanDefinitionHolder>(configCandidates);
        HashSet<ConfigurationClass> hashSet = new HashSet<ConfigurationClass>(configCandidates.size());
        do {
            parser.parse(candidates);
            parser.validate();
            LinkedHashSet<ConfigurationClass> configClasses = new LinkedHashSet<ConfigurationClass>(parser.getConfigurationClasses());
            configClasses.removeAll(hashSet);
            if (this.reader == null) {
                this.reader = new ConfigurationClassBeanDefinitionReader(bootstrapContext, this.importBeanNameGenerator, parser.getImportRegistry());
            }
            this.reader.loadBeanDefinitions(configClasses);
            hashSet.addAll(configClasses);
            candidates.clear();
            if (registry.getBeanDefinitionCount() <= candidateNames.length) continue;
            String[] newCandidateNames = registry.getBeanDefinitionNames();
            HashSet oldCandidateNames = CollectionUtils.newHashSet((Object[])candidateNames);
            HashSet<String> alreadyParsedClasses = new HashSet<String>();
            for (ConfigurationClass configurationClass : hashSet) {
                alreadyParsedClasses.add(configurationClass.metadata.getClassName());
            }
            for (String candidateName : newCandidateNames) {
                BeanDefinition bd;
                if (oldCandidateNames.contains(candidateName) || (bd = registry.getBeanDefinition(candidateName)) == null || !ConfigurationClassUtils.checkConfigurationClassCandidate(bd, metadataReaderFactory) || alreadyParsedClasses.contains(bd.getBeanClassName())) continue;
                candidates.add(new BeanDefinitionHolder(bd, candidateName));
            }
            candidateNames = newCandidateNames;
        } while (!candidates.isEmpty());
        if (sbr != null && !sbr.containsSingleton(IMPORT_REGISTRY_BEAN_NAME)) {
            sbr.registerSingleton(IMPORT_REGISTRY_BEAN_NAME, (Object)parser.getImportRegistry());
        }
        bootstrapContext.clearCache();
    }

    public void enhanceConfigurationClasses(ConfigurableBeanFactory beanFactory) {
        LinkedHashMap<String, AbstractBeanDefinition> configBeanDefs = new LinkedHashMap<String, AbstractBeanDefinition>();
        for (String beanName : beanFactory.getBeanDefinitionNames()) {
            AbstractBeanDefinition abd;
            BeanDefinition beanDef = beanFactory.getBeanDefinition(beanName);
            Object configClassAttr = beanDef.getAttribute(ConfigurationClassUtils.CONFIGURATION_CLASS_ATTRIBUTE);
            AnnotationMetadata annotationMetadata = null;
            MethodMetadata methodMetadata = null;
            if (beanDef instanceof AnnotatedBeanDefinition) {
                AnnotatedBeanDefinition annotatedBeanDefinition = (AnnotatedBeanDefinition)beanDef;
                annotationMetadata = annotatedBeanDefinition.getMetadata();
                methodMetadata = annotatedBeanDefinition.getFactoryMethodMetadata();
            }
            if ((configClassAttr != null || methodMetadata != null) && beanDef instanceof AbstractBeanDefinition && !(abd = (AbstractBeanDefinition)beanDef).hasBeanClass()) {
                boolean liteConfigurationCandidateWithoutBeanMethods;
                boolean bl = liteConfigurationCandidateWithoutBeanMethods = "lite".equals(configClassAttr) && annotationMetadata != null && !ConfigurationClassUtils.hasComponentMethods(annotationMetadata);
                if (!liteConfigurationCandidateWithoutBeanMethods) {
                    try {
                        abd.resolveBeanClass(this.beanClassLoader);
                    }
                    catch (Throwable ex) {
                        throw new IllegalStateException("Cannot load configuration class: " + beanDef.getBeanClassName(), ex);
                    }
                }
            }
            if (!"full".equals(configClassAttr)) continue;
            if (!(beanDef instanceof AbstractBeanDefinition)) {
                throw new BeanDefinitionStoreException("Cannot enhance @Configuration bean definition '" + beanName + "' since it is not stored in an AbstractBeanDefinition subclass");
            }
            abd = (AbstractBeanDefinition)beanDef;
            if (log.isInfoEnabled() && beanFactory.containsSingleton(beanName)) {
                log.info("Cannot enhance @Configuration bean definition '{}' since its singleton instance has been created too early. The typical cause is a non-static @Component method with a BeanDefinitionRegistryPostProcessor return type: Consider declaring such methods as 'static'.", (Object)beanName);
            }
            configBeanDefs.put(beanName, abd);
        }
        if (configBeanDefs.isEmpty()) {
            return;
        }
        ConfigurationClassEnhancer enhancer = new ConfigurationClassEnhancer();
        for (Map.Entry entry : configBeanDefs.entrySet()) {
            Class<?> enhancedClass;
            AbstractBeanDefinition beanDef = (AbstractBeanDefinition)entry.getValue();
            beanDef.setAttribute(AutoProxyUtils.PRESERVE_TARGET_CLASS_ATTRIBUTE, (Object)Boolean.TRUE);
            Class configClass = beanDef.getBeanClass();
            if (configClass == (enhancedClass = enhancer.enhance(configClass, this.beanClassLoader))) continue;
            if (log.isTraceEnabled()) {
                log.trace("Replacing bean definition '{}' existing class '{}' with enhanced class '{}'", new Object[]{entry.getKey(), configClass.getName(), enhancedClass.getName()});
            }
            beanDef.setBeanClass(enhancedClass);
        }
    }

    private record ImportAwareBeanPostProcessor(BeanFactory beanFactory) implements DependenciesBeanPostProcessor,
    InitializationBeanPostProcessor,
    Ordered
    {
        public Object postProcessBeforeInitialization(Object bean, String beanName) {
            if (bean instanceof ImportAware) {
                ImportAware importAware = (ImportAware)bean;
                ImportRegistry registry = (ImportRegistry)this.beanFactory.getBean(IMPORT_REGISTRY_BEAN_NAME, ImportRegistry.class);
                AnnotationMetadata importingClass = registry.getImportingClassFor(ClassUtils.getUserClass((Object)bean).getName());
                if (importingClass != null) {
                    importAware.setImportMetadata(importingClass);
                }
            }
            return bean;
        }

        public PropertyValues processDependencies(PropertyValues propertyValues, Object bean, String beanName) {
            if (bean instanceof ConfigurationClassEnhancer.EnhancedConfiguration) {
                ConfigurationClassEnhancer.EnhancedConfiguration enhancedConfiguration = (ConfigurationClassEnhancer.EnhancedConfiguration)bean;
                enhancedConfiguration.setBeanFactory(this.beanFactory);
            }
            return propertyValues;
        }

        public int getOrder() {
            return Integer.MIN_VALUE;
        }
    }
}

