/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.annotation;

import cn.taketoday.beans.factory.BeanDefinitionStoreException;
import cn.taketoday.beans.factory.annotation.AnnotatedBeanDefinition;
import cn.taketoday.beans.factory.config.BeanDefinition;
import cn.taketoday.beans.factory.config.BeanDefinitionHolder;
import cn.taketoday.beans.factory.parsing.Location;
import cn.taketoday.beans.factory.parsing.Problem;
import cn.taketoday.beans.factory.parsing.ProblemReporter;
import cn.taketoday.beans.factory.support.AbstractBeanDefinition;
import cn.taketoday.context.BootstrapContext;
import cn.taketoday.context.annotation.ComponentMethod;
import cn.taketoday.context.annotation.ComponentScan;
import cn.taketoday.context.annotation.ComponentScanAnnotationParser;
import cn.taketoday.context.annotation.ComponentScans;
import cn.taketoday.context.annotation.ConfigurationClass;
import cn.taketoday.context.annotation.ConfigurationClassUtils;
import cn.taketoday.context.annotation.ConfigurationCondition;
import cn.taketoday.context.annotation.DeferredImportSelector;
import cn.taketoday.context.annotation.Import;
import cn.taketoday.context.annotation.ImportBeanDefinitionRegistrar;
import cn.taketoday.context.annotation.ImportRegistry;
import cn.taketoday.context.annotation.ImportResource;
import cn.taketoday.context.annotation.ImportSelector;
import cn.taketoday.context.annotation.ParserStrategyUtils;
import cn.taketoday.context.annotation.PropertySource;
import cn.taketoday.context.annotation.PropertySources;
import cn.taketoday.core.OrderComparator;
import cn.taketoday.core.Ordered;
import cn.taketoday.core.annotation.AnnotationAwareOrderComparator;
import cn.taketoday.core.annotation.AnnotationUtils;
import cn.taketoday.core.annotation.MergedAnnotation;
import cn.taketoday.core.annotation.MergedAnnotations;
import cn.taketoday.core.env.CompositePropertySource;
import cn.taketoday.core.env.ConfigurableEnvironment;
import cn.taketoday.core.env.Environment;
import cn.taketoday.core.io.EncodedResource;
import cn.taketoday.core.io.PropertySourceFactory;
import cn.taketoday.core.io.Resource;
import cn.taketoday.core.io.ResourcePropertySource;
import cn.taketoday.core.type.AnnotatedTypeMetadata;
import cn.taketoday.core.type.AnnotationMetadata;
import cn.taketoday.core.type.MethodMetadata;
import cn.taketoday.core.type.StandardAnnotationMetadata;
import cn.taketoday.core.type.classreading.MetadataReader;
import cn.taketoday.core.type.classreading.MetadataReaderFactory;
import cn.taketoday.core.type.filter.AssignableTypeFilter;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.logging.Logger;
import cn.taketoday.logging.LoggerFactory;
import cn.taketoday.stereotype.Component;
import cn.taketoday.util.ClassUtils;
import cn.taketoday.util.ExceptionUtils;
import cn.taketoday.util.StringUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;

class ConfigurationClassParser {
    private static final Predicate<String> DEFAULT_EXCLUSION_FILTER = className -> className.startsWith("java.lang.annotation.") || className.startsWith("cn.taketoday.lang.");
    private static final Comparator<DeferredImportSelectorHolder> DEFERRED_IMPORT_COMPARATOR = (o1, o2) -> AnnotationAwareOrderComparator.INSTANCE.compare((Object)o1.importSelector, (Object)o2.importSelector);
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ComponentScanAnnotationParser componentScanParser;
    private final Map<ConfigurationClass, ConfigurationClass> configurationClasses = new LinkedHashMap<ConfigurationClass, ConfigurationClass>();
    private final Map<String, ConfigurationClass> knownSuperclasses = new HashMap<String, ConfigurationClass>();
    private final List<String> propertySourceNames = new ArrayList<String>();
    private final ImportRegistry importStack = new ImportRegistry();
    private final DeferredImportSelectorHandler deferredImportSelectorHandler = new DeferredImportSelectorHandler();
    private final SourceClass objectSourceClass = new SourceClass(Object.class);
    private final BootstrapContext bootstrapContext;

    public ConfigurationClassParser(BootstrapContext bootstrapContext) {
        this.bootstrapContext = bootstrapContext;
        this.componentScanParser = new ComponentScanAnnotationParser(bootstrapContext);
    }

    public void parse(Set<BeanDefinitionHolder> configCandidates) {
        for (BeanDefinitionHolder holder : configCandidates) {
            BeanDefinition bd = holder.getBeanDefinition();
            try {
                if (bd instanceof AnnotatedBeanDefinition) {
                    this.parse(((AnnotatedBeanDefinition)bd).getMetadata(), holder.getBeanName());
                    continue;
                }
                if (bd instanceof AbstractBeanDefinition && ((AbstractBeanDefinition)bd).hasBeanClass()) {
                    this.parse(((AbstractBeanDefinition)bd).getBeanClass(), holder.getBeanName());
                    continue;
                }
                this.parse(bd.getBeanClassName(), holder.getBeanName());
            }
            catch (BeanDefinitionStoreException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                throw new BeanDefinitionStoreException("Failed to parse configuration class [" + bd.getBeanClassName() + "]", ex);
            }
        }
        this.deferredImportSelectorHandler.process();
    }

    protected final void parse(@Nullable String className, String beanName) throws IOException {
        Assert.notNull((Object)className, (String)"No bean class name for configuration class bean definition");
        MetadataReader reader = this.bootstrapContext.getMetadataReader(className);
        this.processConfigurationClass(new ConfigurationClass(reader, beanName), DEFAULT_EXCLUSION_FILTER);
    }

    protected final void parse(Class<?> clazz, String beanName) throws IOException {
        this.processConfigurationClass(new ConfigurationClass(clazz, beanName), DEFAULT_EXCLUSION_FILTER);
    }

    protected final void parse(AnnotationMetadata metadata, String beanName) throws IOException {
        this.processConfigurationClass(new ConfigurationClass(metadata, beanName), DEFAULT_EXCLUSION_FILTER);
    }

    public void validate() {
        ProblemReporter problemReporter = this.bootstrapContext.getProblemReporter();
        for (ConfigurationClass configClass : this.configurationClasses.keySet()) {
            configClass.validate(problemReporter);
        }
    }

    public Set<ConfigurationClass> getConfigurationClasses() {
        return this.configurationClasses.keySet();
    }

    protected void processConfigurationClass(ConfigurationClass configClass, Predicate<String> filter) throws IOException {
        if (this.bootstrapContext.passCondition((AnnotatedTypeMetadata)configClass.metadata, ConfigurationCondition.ConfigurationPhase.PARSE_CONFIGURATION)) {
            ConfigurationClass existingClass = this.configurationClasses.get(configClass);
            if (existingClass != null) {
                if (configClass.isImported()) {
                    if (existingClass.isImported()) {
                        existingClass.mergeImportedBy(configClass);
                    }
                    return;
                }
                this.configurationClasses.remove(configClass);
                this.knownSuperclasses.values().removeIf(configClass::equals);
            }
            SourceClass sourceClass = this.asSourceClass(configClass, filter);
            while ((sourceClass = this.doProcessConfigurationClass(configClass, sourceClass, filter)) != null) {
            }
            this.configurationClasses.put(configClass, configClass);
        }
    }

    @Nullable
    protected final SourceClass doProcessConfigurationClass(ConfigurationClass configClass, SourceClass sourceClass, Predicate<String> filter) throws IOException {
        String superclass;
        if (configClass.metadata.isAnnotated(Component.class.getName())) {
            this.processMemberClasses(configClass, sourceClass, filter);
        }
        Environment environment = this.bootstrapContext.getEnvironment();
        MergedAnnotations annotations = sourceClass.metadata.getAnnotations();
        for (MergedAnnotation<PropertySource> mergedAnnotation : ConfigurationClassParser.repeatable(annotations, PropertySource.class, PropertySources.class)) {
            if (environment instanceof ConfigurableEnvironment) {
                this.processPropertySource(mergedAnnotation);
                continue;
            }
            this.logger.info("Ignoring @PropertySource annotation on [{}]. Reason: Environment must implement ConfigurableEnvironment", (Object)sourceClass.metadata.getClassName());
        }
        Set<MergedAnnotation<ComponentScan>> componentScans = ConfigurationClassParser.repeatable(annotations, ComponentScan.class, ComponentScans.class);
        if (!componentScans.isEmpty() && this.bootstrapContext.passCondition((AnnotatedTypeMetadata)sourceClass.metadata, ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN)) {
            for (MergedAnnotation<ComponentScan> mergedAnnotation : componentScans) {
                Set<BeanDefinitionHolder> scannedBeanDefinitions = this.componentScanParser.parse(mergedAnnotation, sourceClass.metadata.getClassName());
                MetadataReaderFactory metadataReaderFactory = this.bootstrapContext.getMetadataReaderFactory();
                for (BeanDefinitionHolder holder : scannedBeanDefinitions) {
                    BeanDefinition bdCand = holder.getBeanDefinition().getOriginatingBeanDefinition();
                    if (bdCand == null) {
                        bdCand = holder.getBeanDefinition();
                    }
                    if (!ConfigurationClassUtils.checkConfigurationClassCandidate(bdCand, metadataReaderFactory)) continue;
                    this.parse(bdCand.getBeanClassName(), holder.getBeanName());
                }
            }
        }
        this.processImports(configClass, sourceClass, this.getImports(sourceClass), filter, true);
        MergedAnnotation mergedAnnotation = annotations.get(ImportResource.class);
        if (mergedAnnotation.isPresent()) {
            MetadataReaderFactory metadataReaderFactory = mergedAnnotation.getStringArray("locations");
            Class readerClass = mergedAnnotation.getClass("reader");
            for (MetadataReaderFactory resource : metadataReaderFactory) {
                String resolvedResource = environment.resolveRequiredPlaceholders((String)resource);
                configClass.addImportedResource(resolvedResource, readerClass);
            }
        }
        Set<MethodMetadata> set = this.retrieveComponentMethodMetadata(sourceClass);
        for (MethodMetadata methodMetadata : set) {
            configClass.addMethod(new ComponentMethod(methodMetadata, configClass));
        }
        this.processInterfaces(configClass, sourceClass);
        if (sourceClass.metadata.hasSuperClass() && (superclass = sourceClass.metadata.getSuperClassName()) != null && !superclass.startsWith("java") && !this.knownSuperclasses.containsKey(superclass)) {
            this.knownSuperclasses.put(superclass, configClass);
            return sourceClass.getSuperClass();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processMemberClasses(ConfigurationClass configClass, SourceClass sourceClass, Predicate<String> filter) throws IOException {
        Collection<SourceClass> memberClasses = sourceClass.getMemberClasses();
        if (!memberClasses.isEmpty()) {
            ArrayList<SourceClass> candidates = new ArrayList<SourceClass>(memberClasses.size());
            for (SourceClass memberClass : memberClasses) {
                if (!ConfigurationClassUtils.isConfigurationCandidate(memberClass.metadata) || memberClass.metadata.getClassName().equals(configClass.metadata.getClassName())) continue;
                candidates.add(memberClass);
            }
            OrderComparator.sort(candidates);
            for (SourceClass candidate : candidates) {
                if (this.importStack.contains(configClass)) {
                    this.bootstrapContext.reportError(new CircularImportProblem(configClass, this.importStack));
                    continue;
                }
                this.importStack.push(configClass);
                try {
                    this.processConfigurationClass(candidate.asConfigClass(configClass), filter);
                }
                finally {
                    this.importStack.pop();
                }
            }
        }
    }

    private void processInterfaces(ConfigurationClass configClass, SourceClass sourceClass) throws IOException {
        for (SourceClass ifc : sourceClass.getInterfaces()) {
            Set<MethodMetadata> beanMethods = this.retrieveComponentMethodMetadata(ifc);
            for (MethodMetadata methodMetadata : beanMethods) {
                if (methodMetadata.isAbstract()) continue;
                configClass.addMethod(new ComponentMethod(methodMetadata, configClass));
            }
            this.processInterfaces(configClass, ifc);
        }
    }

    private Set<MethodMetadata> retrieveComponentMethodMetadata(SourceClass sourceClass) {
        AnnotationMetadata original = sourceClass.metadata;
        LinkedHashSet<MethodMetadata> componentMethods = original.getAnnotatedMethods(Component.class.getName());
        if (componentMethods.size() > 1 && original instanceof StandardAnnotationMetadata) {
            try {
                AnnotationMetadata asm = this.bootstrapContext.getAnnotationMetadata(original.getClassName());
                Set asmMethods = asm.getAnnotatedMethods(Component.class.getName());
                if (asmMethods.size() >= componentMethods.size()) {
                    LinkedHashSet<MethodMetadata> selectedMethods = new LinkedHashSet<MethodMetadata>(asmMethods.size());
                    block2: for (MethodMetadata asmMethod : asmMethods) {
                        for (MethodMetadata beanMethod : componentMethods) {
                            if (!beanMethod.getMethodName().equals(asmMethod.getMethodName())) continue;
                            selectedMethods.add(beanMethod);
                            continue block2;
                        }
                    }
                    if (selectedMethods.size() == componentMethods.size()) {
                        componentMethods = selectedMethods;
                    }
                }
            }
            catch (Exception ex) {
                this.logger.debug("Failed to read class file via ASM for determining @Component method order", (Throwable)ex);
            }
        }
        return componentMethods;
    }

    private void processPropertySource(MergedAnnotation<PropertySource> propertySource) {
        String[] locations;
        String encoding;
        String name = propertySource.getString("name");
        if (StringUtils.isBlank((String)name)) {
            name = null;
        }
        if (StringUtils.isBlank((String)(encoding = propertySource.getString("encoding")))) {
            encoding = null;
        }
        Assert.isTrue(((locations = propertySource.getStringArray("value")).length > 0 ? 1 : 0) != 0, (String)"At least one @PropertySource(value) location is required");
        Class factoryClass = propertySource.getClass("factory");
        PropertySourceFactory factory = factoryClass == PropertySourceFactory.class ? this.bootstrapContext.getPropertySourceFactory() : (PropertySourceFactory)this.bootstrapContext.instantiate(factoryClass);
        Environment environment = this.bootstrapContext.getEnvironment();
        for (String location : locations) {
            try {
                String resolvedLocation = environment.resolveRequiredPlaceholders(location);
                Resource resource = this.bootstrapContext.getResource(resolvedLocation);
                this.addPropertySource(factory.createPropertySource(name, new EncodedResource(resource, encoding)));
            }
            catch (FileNotFoundException | IllegalArgumentException | SocketException | UnknownHostException ex) {
                if (propertySource.getBoolean("ignoreResourceNotFound")) {
                    if (!this.logger.isInfoEnabled()) continue;
                    this.logger.info("Properties location [{}] not resolvable: {}", (Object)location, (Object)ex.getMessage());
                    continue;
                }
                throw ExceptionUtils.sneakyThrow((Throwable)ex);
            }
            catch (IOException e) {
                throw ExceptionUtils.sneakyThrow((Throwable)e);
            }
        }
    }

    private void addPropertySource(cn.taketoday.core.env.PropertySource<?> propertySource) {
        cn.taketoday.core.env.PropertySource existing;
        String name = propertySource.getName();
        Environment environment = this.bootstrapContext.getEnvironment();
        cn.taketoday.core.env.PropertySources propertySources = ((ConfigurableEnvironment)environment).getPropertySources();
        if (this.propertySourceNames.contains(name) && (existing = propertySources.get(name)) != null) {
            ResourcePropertySource newSource;
            ResourcePropertySource resourcePropertySource = newSource = propertySource instanceof ResourcePropertySource ? ((ResourcePropertySource)propertySource).withResourceName() : propertySource;
            if (existing instanceof CompositePropertySource) {
                ((CompositePropertySource)existing).addFirstPropertySource((cn.taketoday.core.env.PropertySource)newSource);
            } else {
                if (existing instanceof ResourcePropertySource) {
                    existing = ((ResourcePropertySource)existing).withResourceName();
                }
                CompositePropertySource composite = new CompositePropertySource(name);
                composite.addPropertySource((cn.taketoday.core.env.PropertySource)newSource);
                composite.addPropertySource(existing);
                propertySources.replace(name, (cn.taketoday.core.env.PropertySource)composite);
            }
            return;
        }
        if (this.propertySourceNames.isEmpty()) {
            propertySources.addLast(propertySource);
        } else {
            String firstProcessed = this.propertySourceNames.get(this.propertySourceNames.size() - 1);
            propertySources.addBefore(firstProcessed, (cn.taketoday.core.env.PropertySource)propertySource);
        }
        this.propertySourceNames.add(name);
    }

    static <A extends Annotation, C extends Annotation> Set<MergedAnnotation<A>> repeatable(MergedAnnotations annotations, Class<A> annotationType, Class<C> con) {
        return ConfigurationClassParser.repeatable(annotations, annotationType, con, "value");
    }

    static <A extends Annotation, C extends Annotation> Set<MergedAnnotation<A>> repeatable(MergedAnnotations annotations, Class<A> annotationType, Class<C> container, String attributeName) {
        LinkedHashSet<MergedAnnotation<A>> result = new LinkedHashSet<MergedAnnotation<A>>();
        ConfigurationClassParser.addAttributesIfNotNull(result, annotations.get(annotationType));
        MergedAnnotation annotation = annotations.get(container);
        if (annotation.isPresent()) {
            MergedAnnotation[] repeatable;
            for (MergedAnnotation mergedAnnotation : repeatable = annotation.getAnnotationArray(attributeName, annotationType)) {
                ConfigurationClassParser.addAttributesIfNotNull(result, mergedAnnotation);
            }
        }
        return result;
    }

    private static <A extends Annotation> void addAttributesIfNotNull(Set<MergedAnnotation<A>> result, MergedAnnotation<A> propertySource) {
        if (propertySource.isPresent()) {
            result.add(propertySource);
        }
    }

    private Set<SourceClass> getImports(SourceClass sourceClass) throws IOException {
        LinkedHashSet<SourceClass> imports = new LinkedHashSet<SourceClass>();
        LinkedHashSet<SourceClass> visited = new LinkedHashSet<SourceClass>();
        this.collectImports(sourceClass, imports, visited);
        return imports;
    }

    private void collectImports(SourceClass sourceClass, Set<SourceClass> imports, Set<SourceClass> visited) throws IOException {
        if (visited.add(sourceClass)) {
            for (SourceClass annotation : sourceClass.getAnnotationsAsSourceClass()) {
                String annName = annotation.metadata.getClassName();
                if (annName.equals(Import.class.getName())) continue;
                this.collectImports(annotation, imports, visited);
            }
            imports.addAll(sourceClass.getAnnotationAttributes(Import.class.getName(), "value"));
        }
    }

    private void processImports(ConfigurationClass configClass, SourceClass currentSourceClass, Collection<SourceClass> importCandidates, Predicate<String> exclusionFilter, boolean checkForCircularImports) {
        if (importCandidates.isEmpty()) {
            return;
        }
        if (checkForCircularImports && this.isChainedImportOnStack(configClass)) {
            this.bootstrapContext.reportError(new CircularImportProblem(configClass, this.importStack));
        } else {
            this.importStack.push(configClass);
            try {
                for (SourceClass candidate : importCandidates) {
                    Class<?> candidateClass;
                    if (candidate.isAssignable(ImportSelector.class)) {
                        candidateClass = candidate.loadClass();
                        ImportSelector selector = ParserStrategyUtils.newInstance(candidateClass, ImportSelector.class, this.bootstrapContext);
                        Predicate<String> selectorFilter = selector.getExclusionFilter();
                        if (selectorFilter != null) {
                            exclusionFilter = exclusionFilter.or(selectorFilter);
                        }
                        if (selector instanceof DeferredImportSelector) {
                            DeferredImportSelector deferredSelector = (DeferredImportSelector)selector;
                            this.deferredImportSelectorHandler.handle(configClass, deferredSelector);
                            continue;
                        }
                        String[] importClassNames = selector.selectImports(currentSourceClass.metadata);
                        Collection<SourceClass> importSourceClasses = this.asSourceClasses(importClassNames, exclusionFilter);
                        this.processImports(configClass, currentSourceClass, importSourceClasses, exclusionFilter, false);
                        continue;
                    }
                    if (candidate.isAssignable(ImportBeanDefinitionRegistrar.class)) {
                        candidateClass = candidate.loadClass();
                        ImportBeanDefinitionRegistrar registrar = ParserStrategyUtils.newInstance(candidateClass, ImportBeanDefinitionRegistrar.class, this.bootstrapContext);
                        configClass.addImportBeanDefinitionRegistrar(registrar, currentSourceClass.metadata);
                        continue;
                    }
                    this.importStack.registerImport(currentSourceClass.metadata, candidate.metadata.getClassName());
                    this.processConfigurationClass(candidate.asConfigClass(configClass), exclusionFilter);
                }
            }
            catch (BeanDefinitionStoreException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                throw new BeanDefinitionStoreException("Failed to process import candidates for configuration class [" + configClass.metadata.getClassName() + "]: " + ex.getMessage(), ex);
            }
            finally {
                this.importStack.pop();
            }
        }
    }

    private boolean isChainedImportOnStack(ConfigurationClass configClass) {
        if (this.importStack.contains(configClass)) {
            String configClassName = configClass.metadata.getClassName();
            AnnotationMetadata importingClass = this.importStack.getImportingClassFor(configClassName);
            while (importingClass != null) {
                if (configClassName.equals(importingClass.getClassName())) {
                    return true;
                }
                importingClass = this.importStack.getImportingClassFor(importingClass.getClassName());
            }
        }
        return false;
    }

    ImportRegistry getImportRegistry() {
        return this.importStack;
    }

    private SourceClass asSourceClass(ConfigurationClass configurationClass, Predicate<String> filter) throws IOException {
        AnnotationMetadata metadata = configurationClass.metadata;
        if (metadata instanceof StandardAnnotationMetadata) {
            return this.asSourceClass(((StandardAnnotationMetadata)metadata).getIntrospectedClass(), filter);
        }
        return this.asSourceClass(metadata.getClassName(), filter);
    }

    SourceClass asSourceClass(@Nullable Class<?> classType, Predicate<String> filter) throws IOException {
        if (classType == null || filter.test(classType.getName())) {
            return this.objectSourceClass;
        }
        try {
            for (Annotation ann : classType.getDeclaredAnnotations()) {
                AnnotationUtils.validateAnnotation((Annotation)ann);
            }
            return new SourceClass(classType);
        }
        catch (Throwable ex) {
            return this.asSourceClass(classType.getName(), filter);
        }
    }

    private Collection<SourceClass> asSourceClasses(String[] classNames, Predicate<String> filter) throws IOException {
        ArrayList<SourceClass> annotatedClasses = new ArrayList<SourceClass>(classNames.length);
        for (String className : classNames) {
            annotatedClasses.add(this.asSourceClass(className, filter));
        }
        return annotatedClasses;
    }

    SourceClass asSourceClass(@Nullable String className, Predicate<String> filter) throws IOException {
        if (className == null || filter.test(className)) {
            return this.objectSourceClass;
        }
        if (className.startsWith("java")) {
            try {
                return new SourceClass(ClassUtils.forName((String)className, (ClassLoader)this.bootstrapContext.getClassLoader()));
            }
            catch (ClassNotFoundException ex) {
                throw new IOException("Failed to load class [" + className + "]", ex);
            }
        }
        return new SourceClass(this.bootstrapContext.getMetadataReader(className));
    }

    private class DeferredImportSelectorHandler {
        @Nullable
        private ArrayList<DeferredImportSelectorHolder> deferredImportSelectors = new ArrayList();

        private DeferredImportSelectorHandler() {
        }

        public void handle(ConfigurationClass configClass, DeferredImportSelector importSelector) {
            DeferredImportSelectorHolder holder = new DeferredImportSelectorHolder(configClass, importSelector);
            if (this.deferredImportSelectors == null) {
                DeferredImportSelectorGroupingHandler handler = new DeferredImportSelectorGroupingHandler();
                handler.register(holder);
                handler.processGroupImports();
            } else {
                this.deferredImportSelectors.add(holder);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process() {
            ArrayList<DeferredImportSelectorHolder> deferredImports = this.deferredImportSelectors;
            this.deferredImportSelectors = null;
            try {
                if (deferredImports != null) {
                    DeferredImportSelectorGroupingHandler handler = new DeferredImportSelectorGroupingHandler();
                    deferredImports.sort(DEFERRED_IMPORT_COMPARATOR);
                    for (DeferredImportSelectorHolder deferredImport : deferredImports) {
                        handler.register(deferredImport);
                    }
                    handler.processGroupImports();
                }
            }
            finally {
                this.deferredImportSelectors = new ArrayList();
            }
        }
    }

    private class SourceClass
    implements Ordered {
        private final Object source;
        private final AnnotationMetadata metadata;

        public SourceClass(Object source) {
            this.source = source;
            this.metadata = source instanceof Class ? AnnotationMetadata.introspect((Class)((Class)source)) : ((MetadataReader)source).getAnnotationMetadata();
        }

        public int getOrder() {
            Integer order = ConfigurationClassUtils.getOrder(this.metadata);
            return order != null ? order : Integer.MAX_VALUE;
        }

        public Class<?> loadClass() throws ClassNotFoundException {
            if (this.source instanceof Class) {
                return (Class)this.source;
            }
            String className = ((MetadataReader)this.source).getClassMetadata().getClassName();
            return ClassUtils.forName((String)className, (ClassLoader)ConfigurationClassParser.this.bootstrapContext.getClassLoader());
        }

        public boolean isAssignable(Class<?> clazz) throws IOException {
            if (this.source instanceof Class) {
                return clazz.isAssignableFrom((Class)this.source);
            }
            return new AssignableTypeFilter(clazz).match((MetadataReader)this.source, ConfigurationClassParser.this.bootstrapContext.getMetadataReaderFactory());
        }

        public ConfigurationClass asConfigClass(ConfigurationClass importedBy) {
            if (this.source instanceof Class) {
                return new ConfigurationClass((Class)this.source, importedBy);
            }
            return new ConfigurationClass((MetadataReader)this.source, importedBy);
        }

        public Collection<SourceClass> getMemberClasses() throws IOException {
            Object sourceToProcess = this.source;
            if (sourceToProcess instanceof Class) {
                Class sourceClass = (Class)sourceToProcess;
                try {
                    Class<?>[] declaredClasses = sourceClass.getDeclaredClasses();
                    ArrayList<SourceClass> members = new ArrayList<SourceClass>(declaredClasses.length);
                    for (Class<?> declaredClass : declaredClasses) {
                        members.add(ConfigurationClassParser.this.asSourceClass(declaredClass, DEFAULT_EXCLUSION_FILTER));
                    }
                    return members;
                }
                catch (NoClassDefFoundError err) {
                    sourceToProcess = ConfigurationClassParser.this.bootstrapContext.getMetadataReader(sourceClass.getName());
                }
            }
            MetadataReader sourceReader = (MetadataReader)sourceToProcess;
            String[] memberClassNames = sourceReader.getClassMetadata().getMemberClassNames();
            ArrayList<SourceClass> members = new ArrayList<SourceClass>(memberClassNames.length);
            for (String memberClassName : memberClassNames) {
                try {
                    members.add(ConfigurationClassParser.this.asSourceClass(memberClassName, DEFAULT_EXCLUSION_FILTER));
                }
                catch (IOException ex) {
                    ConfigurationClassParser.this.logger.debug("Failed to resolve member class [{}] - not considering it as a configuration class candidate", (Object)memberClassName);
                }
            }
            return members;
        }

        public SourceClass getSuperClass() throws IOException {
            if (this.source instanceof Class) {
                return ConfigurationClassParser.this.asSourceClass(((Class)this.source).getSuperclass(), DEFAULT_EXCLUSION_FILTER);
            }
            return ConfigurationClassParser.this.asSourceClass(((MetadataReader)this.source).getClassMetadata().getSuperClassName(), DEFAULT_EXCLUSION_FILTER);
        }

        public LinkedHashSet<SourceClass> getInterfaces() throws IOException {
            LinkedHashSet<SourceClass> result = new LinkedHashSet<SourceClass>();
            Object[] objectArray = this.source;
            if (objectArray instanceof Class) {
                Class sourceClass = (Class)objectArray;
                for (Class<?> ifcClass : sourceClass.getInterfaces()) {
                    result.add(ConfigurationClassParser.this.asSourceClass(ifcClass, DEFAULT_EXCLUSION_FILTER));
                }
            } else {
                for (String className : this.metadata.getInterfaceNames()) {
                    result.add(ConfigurationClassParser.this.asSourceClass(className, DEFAULT_EXCLUSION_FILTER));
                }
            }
            return result;
        }

        public Set<SourceClass> getAnnotationsAsSourceClass() {
            LinkedHashSet<SourceClass> result = new LinkedHashSet<SourceClass>();
            Annotation[] annotationArray = this.source;
            if (annotationArray instanceof Class) {
                Class sourceClass = (Class)annotationArray;
                for (Annotation ann : sourceClass.getDeclaredAnnotations()) {
                    Class<? extends Annotation> annType = ann.annotationType();
                    if (annType.getName().startsWith("java")) continue;
                    try {
                        result.add(ConfigurationClassParser.this.asSourceClass(annType, DEFAULT_EXCLUSION_FILTER));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            } else {
                for (String className : this.metadata.getAnnotationTypes()) {
                    if (className.startsWith("java")) continue;
                    try {
                        result.add(this.getRelated(className));
                    }
                    catch (Throwable throwable) {}
                }
            }
            return result;
        }

        public Collection<SourceClass> getAnnotationAttributes(String annType, String attribute) throws IOException {
            Optional optional;
            MergedAnnotation annotation = this.metadata.getAnnotation(annType);
            if (annotation.isPresent() && (optional = annotation.getValue(attribute, String[].class)).isPresent()) {
                String[] classNames = (String[])optional.get();
                LinkedHashSet<SourceClass> result = new LinkedHashSet<SourceClass>();
                for (String className : classNames) {
                    result.add(this.getRelated(className));
                }
                return result;
            }
            return Collections.emptySet();
        }

        private SourceClass getRelated(String className) throws IOException {
            if (this.source instanceof Class) {
                try {
                    Class clazz = ClassUtils.forName((String)className, (ClassLoader)((Class)this.source).getClassLoader());
                    return ConfigurationClassParser.this.asSourceClass(clazz, DEFAULT_EXCLUSION_FILTER);
                }
                catch (ClassNotFoundException ex) {
                    if (className.startsWith("java")) {
                        throw new IOException("Failed to load class [" + className + "]", ex);
                    }
                    return new SourceClass(ConfigurationClassParser.this.bootstrapContext.getMetadataReader(className));
                }
            }
            return ConfigurationClassParser.this.asSourceClass(className, DEFAULT_EXCLUSION_FILTER);
        }

        public boolean equals(@Nullable Object other) {
            return this == other || other instanceof SourceClass && this.metadata.getClassName().equals(((SourceClass)other).metadata.getClassName());
        }

        public int hashCode() {
            return this.metadata.getClassName().hashCode();
        }

        public String toString() {
            return this.metadata.getClassName();
        }
    }

    private static class CircularImportProblem
    extends Problem {
        public CircularImportProblem(ConfigurationClass attemptedImport, Deque<ConfigurationClass> importStack) {
            super(String.format("A circular @Import has been detected: Illegal attempt by @Configuration class '%s' to import class '%s' as '%s' is already present in the current import stack %s", importStack.element().getSimpleName(), attemptedImport.getSimpleName(), attemptedImport.getSimpleName(), importStack), new Location(importStack.element().resource, (Object)attemptedImport.metadata));
        }
    }

    private static class DeferredImportSelectorHolder {
        public final ConfigurationClass configurationClass;
        public final DeferredImportSelector importSelector;

        public DeferredImportSelectorHolder(ConfigurationClass configClass, DeferredImportSelector selector) {
            this.configurationClass = configClass;
            this.importSelector = selector;
        }
    }

    private static class DefaultDeferredImportSelectorGroup
    implements DeferredImportSelector.Group {
        private final ArrayList<DeferredImportSelector.Group.Entry> imports = new ArrayList();

        private DefaultDeferredImportSelectorGroup() {
        }

        @Override
        public void process(AnnotationMetadata metadata, DeferredImportSelector selector) {
            for (String importClassName : selector.selectImports(metadata)) {
                this.imports.add(new DeferredImportSelector.Group.Entry(metadata, importClassName));
            }
        }

        @Override
        public Iterable<DeferredImportSelector.Group.Entry> selectImports() {
            return this.imports;
        }
    }

    private static class DeferredImportSelectorGrouping {
        private final DeferredImportSelector.Group group;
        private final List<DeferredImportSelectorHolder> deferredImports = new ArrayList<DeferredImportSelectorHolder>();

        DeferredImportSelectorGrouping(DeferredImportSelector.Group group) {
            this.group = group;
        }

        public void add(DeferredImportSelectorHolder deferredImport) {
            this.deferredImports.add(deferredImport);
        }

        public Iterable<DeferredImportSelector.Group.Entry> getImports() {
            for (DeferredImportSelectorHolder deferredImport : this.deferredImports) {
                this.group.process(deferredImport.configurationClass.metadata, deferredImport.importSelector);
            }
            return this.group.selectImports();
        }

        public Predicate<String> getCandidateFilter() {
            Predicate<String> mergedFilter = DEFAULT_EXCLUSION_FILTER;
            for (DeferredImportSelectorHolder deferredImport : this.deferredImports) {
                Predicate<String> selectorFilter = deferredImport.importSelector.getExclusionFilter();
                if (selectorFilter == null) continue;
                mergedFilter = mergedFilter.or(selectorFilter);
            }
            return mergedFilter;
        }
    }

    private class DeferredImportSelectorGroupingHandler {
        private final HashMap<AnnotationMetadata, ConfigurationClass> configurationClasses = new HashMap();
        private final LinkedHashMap<Object, DeferredImportSelectorGrouping> groupings = new LinkedHashMap();

        private DeferredImportSelectorGroupingHandler() {
        }

        public void register(DeferredImportSelectorHolder deferredImport) {
            Class<? extends DeferredImportSelector.Group> group = deferredImport.importSelector.getImportGroup();
            DeferredImportSelectorGrouping grouping = this.groupings.computeIfAbsent(group != null ? group : deferredImport, key -> new DeferredImportSelectorGrouping(this.createGroup(group)));
            grouping.add(deferredImport);
            this.configurationClasses.put(deferredImport.configurationClass.metadata, deferredImport.configurationClass);
        }

        public void processGroupImports() {
            for (DeferredImportSelectorGrouping grouping : this.groupings.values()) {
                Predicate<String> exclusionFilter = grouping.getCandidateFilter();
                for (DeferredImportSelector.Group.Entry entry : grouping.getImports()) {
                    ConfigurationClass configurationClass = this.configurationClasses.get(entry.metadata());
                    try {
                        ConfigurationClassParser.this.processImports(configurationClass, ConfigurationClassParser.this.asSourceClass(configurationClass, exclusionFilter), Collections.singleton(ConfigurationClassParser.this.asSourceClass(entry.importClassName(), exclusionFilter)), exclusionFilter, false);
                    }
                    catch (BeanDefinitionStoreException ex) {
                        throw ex;
                    }
                    catch (Throwable ex) {
                        throw new BeanDefinitionStoreException("Failed to process import candidates for configuration class [" + configurationClass.metadata.getClassName() + "]", ex);
                    }
                }
            }
        }

        private DeferredImportSelector.Group createGroup(@Nullable Class<? extends DeferredImportSelector.Group> type) {
            Class<? extends DeferredImportSelector.Group> effectiveType = type != null ? type : DefaultDeferredImportSelectorGroup.class;
            return ParserStrategyUtils.newInstance(effectiveType, DeferredImportSelector.Group.class, ConfigurationClassParser.this.bootstrapContext);
        }
    }
}

