/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.annotation;

import cn.taketoday.aop.framework.StandardProxy;
import cn.taketoday.aop.scope.ScopedProxyFactoryBean;
import cn.taketoday.beans.BeanInstantiationException;
import cn.taketoday.beans.factory.BeanFactory;
import cn.taketoday.beans.factory.BeanFactoryAware;
import cn.taketoday.beans.factory.NoSuchBeanDefinitionException;
import cn.taketoday.beans.factory.config.BeanDefinition;
import cn.taketoday.beans.factory.config.BeanFactoryPostProcessor;
import cn.taketoday.beans.factory.config.ConfigurableBeanFactory;
import cn.taketoday.beans.factory.support.InstantiationStrategy;
import cn.taketoday.beans.support.BeanInstantiator;
import cn.taketoday.bytecode.Type;
import cn.taketoday.bytecode.core.ClassGenerator;
import cn.taketoday.bytecode.core.ClassLoaderAwareGeneratorStrategy;
import cn.taketoday.bytecode.core.GeneratorStrategy;
import cn.taketoday.bytecode.proxy.Callback;
import cn.taketoday.bytecode.proxy.CallbackFilter;
import cn.taketoday.bytecode.proxy.Enhancer;
import cn.taketoday.bytecode.proxy.Factory;
import cn.taketoday.bytecode.proxy.MethodInterceptor;
import cn.taketoday.bytecode.proxy.MethodProxy;
import cn.taketoday.bytecode.proxy.NoOp;
import cn.taketoday.bytecode.transform.ClassEmitterTransformer;
import cn.taketoday.bytecode.transform.ClassTransformer;
import cn.taketoday.bytecode.transform.TransformingClassGenerator;
import cn.taketoday.context.annotation.BeanAnnotationHelper;
import cn.taketoday.context.annotation.ScopedProxyCreator;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.logging.Logger;
import cn.taketoday.logging.LoggerFactory;
import cn.taketoday.util.ClassUtils;
import cn.taketoday.util.ObjectUtils;
import cn.taketoday.util.ReflectionUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.Arrays;

class ConfigurationClassEnhancer {
    private static final Callback[] CALLBACKS = new Callback[]{new ComponentMethodInterceptor(), new BeanFactoryAwareMethodInterceptor(), NoOp.INSTANCE};
    private static final ConditionalCallbackFilter CALLBACK_FILTER = new ConditionalCallbackFilter(CALLBACKS);
    private static final String BEAN_FACTORY_FIELD = "$$beanFactory";
    private static final Logger log = LoggerFactory.getLogger(ConfigurationClassEnhancer.class);

    ConfigurationClassEnhancer() {
    }

    public Class<?> enhance(Class<?> configClass, @Nullable ClassLoader classLoader) {
        if (EnhancedConfiguration.class.isAssignableFrom(configClass)) {
            if (log.isDebugEnabled()) {
                log.debug("Ignoring request to enhance {} as it has already been enhanced. This usually indicates that more than one ConfigurationClassPostProcessor has been registered. This is harmless, but you may want check your configuration and remove one CCPP if possible", (Object)configClass.getName());
            }
            return configClass;
        }
        Class<?> enhancedClass = this.createClass(this.newEnhancer(configClass, classLoader));
        if (log.isTraceEnabled()) {
            log.trace("Successfully enhanced {}; enhanced class name is: {}", (Object)configClass.getName(), (Object)enhancedClass.getName());
        }
        return enhancedClass;
    }

    private Enhancer newEnhancer(Class<?> configSuperClass, @Nullable ClassLoader classLoader) {
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(configSuperClass);
        enhancer.setInterfaces(new Class[]{EnhancedConfiguration.class});
        enhancer.setUseFactory(false);
        enhancer.setStrategy((GeneratorStrategy)new BeanFactoryAwareGeneratorStrategy(classLoader));
        enhancer.setCallbackFilter((CallbackFilter)CALLBACK_FILTER);
        enhancer.setCallbackTypes((Class[])CALLBACK_FILTER.getCallbackTypes());
        return enhancer;
    }

    private Class<?> createClass(Enhancer enhancer) {
        Class subclass = enhancer.createClass();
        Enhancer.registerStaticCallbacks((Class)subclass, (Callback[])CALLBACKS);
        return subclass;
    }

    public static interface EnhancedConfiguration
    extends BeanFactoryAware,
    StandardProxy {
    }

    private static class BeanFactoryAwareGeneratorStrategy
    extends ClassLoaderAwareGeneratorStrategy {
        public BeanFactoryAwareGeneratorStrategy(@Nullable ClassLoader classLoader) {
            super(classLoader);
        }

        protected ClassGenerator transform(ClassGenerator cg) throws Exception {
            ClassEmitterTransformer transformer = new ClassEmitterTransformer(){

                public void endClass() {
                    this.declare_field(1, ConfigurationClassEnhancer.BEAN_FACTORY_FIELD, Type.fromClass(BeanFactory.class), null);
                    super.endClass();
                }
            };
            return new TransformingClassGenerator(cg, (ClassTransformer)transformer);
        }
    }

    private static class ConditionalCallbackFilter
    implements CallbackFilter {
        private final Callback[] callbacks;
        private final Class<?>[] callbackTypes;

        public ConditionalCallbackFilter(Callback[] callbacks) {
            this.callbacks = callbacks;
            this.callbackTypes = new Class[callbacks.length];
            for (int i = 0; i < callbacks.length; ++i) {
                this.callbackTypes[i] = callbacks[i].getClass();
            }
        }

        public int accept(Method method) {
            for (int i = 0; i < this.callbacks.length; ++i) {
                Callback callback = this.callbacks[i];
                if (callback instanceof ConditionalCallback && !((ConditionalCallback)callback).isMatch(method)) continue;
                return i;
            }
            throw new IllegalStateException("No callback available for method " + method.getName());
        }

        public Class<?>[] getCallbackTypes() {
            return this.callbackTypes;
        }
    }

    private static class ComponentMethodInterceptor
    implements MethodInterceptor,
    ConditionalCallback {
        private ComponentMethodInterceptor() {
        }

        @Nullable
        public Object intercept(Object enhancedConfigInstance, Method beanMethod, Object[] beanMethodArgs, MethodProxy cglibMethodProxy) throws Throwable {
            Object factoryBean;
            String scopedBeanName;
            ConfigurableBeanFactory beanFactory = this.getBeanFactory(enhancedConfigInstance);
            String beanName = BeanAnnotationHelper.determineBeanNameFor(beanMethod);
            if (BeanAnnotationHelper.isScopedProxy(beanMethod) && beanFactory.isCurrentlyInCreation(scopedBeanName = ScopedProxyCreator.getTargetBeanName(beanName))) {
                beanName = scopedBeanName;
            }
            if (this.factoryContainsBean(beanFactory, "&" + beanName) && this.factoryContainsBean(beanFactory, beanName) && !((factoryBean = beanFactory.getBean("&" + beanName)) instanceof ScopedProxyFactoryBean)) {
                return this.enhanceFactoryBean(factoryBean, beanMethod.getReturnType(), beanFactory, beanName);
            }
            if (this.isCurrentlyInvokedFactoryMethod(beanMethod)) {
                if (log.isInfoEnabled() && BeanFactoryPostProcessor.class.isAssignableFrom(beanMethod.getReturnType())) {
                    log.info("@Component method {}.{} is non-static and returns an object assignable to Framework's BeanFactoryPostProcessor interface. This will result in a failure to process annotations such as @Autowired, @Resource and @PostConstruct within the method's declaring @Configuration class. Add the 'static' modifier to this method to avoid these container lifecycle issues; see @Component javadoc for complete details.", (Object)beanMethod.getDeclaringClass().getSimpleName(), (Object)beanMethod.getName());
                }
                return cglibMethodProxy.invokeSuper(enhancedConfigInstance, beanMethodArgs);
            }
            return this.resolveBeanReference(beanMethod, beanMethodArgs, beanFactory, beanName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object resolveBeanReference(Method beanMethod, Object[] beanMethodArgs, ConfigurableBeanFactory beanFactory, String beanName) {
            boolean alreadyInCreation = beanFactory.isCurrentlyInCreation(beanName);
            try {
                Method currentlyInvoked;
                Object beanInstance;
                boolean useArgs;
                if (alreadyInCreation) {
                    beanFactory.setCurrentlyInCreation(beanName, false);
                }
                if ((useArgs = ObjectUtils.isNotEmpty((Object[])beanMethodArgs)) && beanFactory.isSingleton(beanName)) {
                    for (Object arg : beanMethodArgs) {
                        if (arg != null) continue;
                        useArgs = false;
                        break;
                    }
                }
                Object object = beanInstance = useArgs ? beanFactory.getBean(beanName, beanMethodArgs) : beanFactory.getBean(beanName);
                if (!ClassUtils.isAssignableValue(beanMethod.getReturnType(), (Object)beanInstance)) {
                    if (beanInstance == null) {
                        if (log.isDebugEnabled()) {
                            log.debug(String.format("@Component method %s.%s called as bean reference for type [%s] returned null bean; resolving to null value.", beanMethod.getDeclaringClass().getSimpleName(), beanMethod.getName(), beanMethod.getReturnType().getName()));
                        }
                    } else {
                        Object msg = String.format("@Component method %s.%s called as bean reference for type [%s] but overridden by non-compatible bean instance of type [%s].", beanMethod.getDeclaringClass().getSimpleName(), beanMethod.getName(), beanMethod.getReturnType().getName(), beanInstance.getClass().getName());
                        try {
                            BeanDefinition beanDefinition = beanFactory.getMergedBeanDefinition(beanName);
                            msg = (String)msg + " Overriding bean of same name declared in: " + beanDefinition.getResourceDescription();
                        }
                        catch (NoSuchBeanDefinitionException beanDefinition) {
                            // empty catch block
                        }
                        throw new IllegalStateException((String)msg);
                    }
                }
                if ((currentlyInvoked = InstantiationStrategy.getCurrentlyInvokedFactoryMethod()) != null) {
                    String outerBeanName = BeanAnnotationHelper.determineBeanNameFor(currentlyInvoked);
                    beanFactory.registerDependentBean(beanName, outerBeanName);
                }
                Object object2 = beanInstance;
                return object2;
            }
            finally {
                if (alreadyInCreation) {
                    beanFactory.setCurrentlyInCreation(beanName, true);
                }
            }
        }

        @Override
        public boolean isMatch(Method candidateMethod) {
            return candidateMethod.getDeclaringClass() != Object.class && !BeanFactoryAwareMethodInterceptor.isSetBeanFactory(candidateMethod) && BeanAnnotationHelper.isBeanAnnotated(candidateMethod);
        }

        private ConfigurableBeanFactory getBeanFactory(Object enhancedConfigInstance) {
            Field field = ReflectionUtils.findField(enhancedConfigInstance.getClass(), (String)ConfigurationClassEnhancer.BEAN_FACTORY_FIELD);
            Assert.state((field != null ? 1 : 0) != 0, (String)"Unable to find generated bean factory field");
            Object beanFactory = ReflectionUtils.getField((Field)field, (Object)enhancedConfigInstance);
            Assert.state((beanFactory != null ? 1 : 0) != 0, (String)"BeanFactory has not been injected into @Configuration class");
            Assert.state((boolean)(beanFactory instanceof ConfigurableBeanFactory), (String)"Injected BeanFactory is not a ConfigurableBeanFactory");
            return (ConfigurableBeanFactory)beanFactory;
        }

        private boolean factoryContainsBean(ConfigurableBeanFactory beanFactory, String beanName) {
            return beanFactory.containsBean(beanName) && !beanFactory.isCurrentlyInCreation(beanName);
        }

        private boolean isCurrentlyInvokedFactoryMethod(Method method) {
            Method currentlyInvoked = InstantiationStrategy.getCurrentlyInvokedFactoryMethod();
            return currentlyInvoked != null && method.getName().equals(currentlyInvoked.getName()) && Arrays.equals(method.getParameterTypes(), currentlyInvoked.getParameterTypes());
        }

        private Object enhanceFactoryBean(Object factoryBean, Class<?> exposedType, ConfigurableBeanFactory beanFactory, String beanName) {
            try {
                Class<?> clazz = factoryBean.getClass();
                boolean finalClass = Modifier.isFinal(clazz.getModifiers());
                boolean finalMethod = Modifier.isFinal(clazz.getMethod("getObject", new Class[0]).getModifiers());
                if (finalClass || finalMethod) {
                    if (exposedType.isInterface()) {
                        if (log.isTraceEnabled()) {
                            log.trace("Creating interface proxy for FactoryBean '{}' of type [{}] for use within another @Component method because its {} is final: Otherwise a getObject() call would not be routed to the factory.", new Object[]{beanName, clazz.getName(), finalClass ? "implementation class" : "getObject() method"});
                        }
                        return this.createInterfaceProxyForFactoryBean(factoryBean, exposedType, beanFactory, beanName);
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("Unable to proxy FactoryBean '{}' of type [{}] for use within another @Component method because its {} is final: A getObject() call will NOT be routed to the factory. Consider declaring the return type as a FactoryBean interface.", new Object[]{beanName, clazz.getName(), finalClass ? "implementation class" : "getObject() method"});
                    }
                    return factoryBean;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            return this.createCglibProxyForFactoryBean(factoryBean, beanFactory, beanName);
        }

        private Object createInterfaceProxyForFactoryBean(Object factoryBean, Class<?> interfaceType, ConfigurableBeanFactory beanFactory, String beanName) {
            return Proxy.newProxyInstance(factoryBean.getClass().getClassLoader(), new Class[]{interfaceType}, (proxy, method, args) -> {
                if (method.getName().equals("getObject") && args == null) {
                    return beanFactory.getBean(beanName);
                }
                return ReflectionUtils.invokeMethod((Method)method, (Object)factoryBean, (Object[])args);
            });
        }

        private Object createCglibProxyForFactoryBean(Object factoryBean, ConfigurableBeanFactory beanFactory, String beanName) {
            Object fbProxy;
            Enhancer enhancer = new Enhancer();
            enhancer.setSuperclass(factoryBean.getClass());
            enhancer.setCallbackType(MethodInterceptor.class);
            Class fbClass = enhancer.createClass();
            try {
                fbProxy = ReflectionUtils.accessibleConstructor((Class)fbClass, (Class[])new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable ex) {
                try {
                    fbProxy = BeanInstantiator.forSerialization((Class)fbClass).instantiate();
                }
                catch (BeanInstantiationException ignored) {
                    throw new IllegalStateException("Unable to instantiate enhanced FactoryBean using constructor, and regular FactoryBean instantiation via default constructor fails as well", ex);
                }
            }
            ((Factory)fbProxy).setCallback(0, (Callback)((MethodInterceptor)(obj, method, args, proxy) -> {
                if (method.getName().equals("getObject") && args.length == 0) {
                    return beanFactory.getBean(beanName);
                }
                return proxy.invoke(factoryBean, args);
            }));
            return fbProxy;
        }
    }

    private static class BeanFactoryAwareMethodInterceptor
    implements MethodInterceptor,
    ConditionalCallback {
        private BeanFactoryAwareMethodInterceptor() {
        }

        @Nullable
        public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
            Field field = ReflectionUtils.findField(obj.getClass(), (String)ConfigurationClassEnhancer.BEAN_FACTORY_FIELD);
            Assert.state((field != null ? 1 : 0) != 0, (String)"Unable to find generated BeanFactory field");
            field.set(obj, args[0]);
            if (BeanFactoryAware.class.isAssignableFrom(ClassUtils.getUserClass(obj.getClass().getSuperclass()))) {
                return proxy.invokeSuper(obj, args);
            }
            return null;
        }

        @Override
        public boolean isMatch(Method candidateMethod) {
            return BeanFactoryAwareMethodInterceptor.isSetBeanFactory(candidateMethod);
        }

        public static boolean isSetBeanFactory(Method candidateMethod) {
            return candidateMethod.getName().equals("setBeanFactory") && candidateMethod.getParameterCount() == 1 && BeanFactory.class == candidateMethod.getParameterTypes()[0] && BeanFactoryAware.class.isAssignableFrom(candidateMethod.getDeclaringClass());
        }
    }

    private static interface ConditionalCallback
    extends Callback {
        public boolean isMatch(Method var1);
    }
}

