/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.annotation;

import cn.taketoday.beans.factory.BeanDefinitionStoreException;
import cn.taketoday.beans.factory.annotation.AnnotatedBeanDefinition;
import cn.taketoday.beans.factory.annotation.AnnotatedGenericBeanDefinition;
import cn.taketoday.beans.factory.annotation.DisableAllDependencyInjection;
import cn.taketoday.beans.factory.annotation.DisableDependencyInjection;
import cn.taketoday.beans.factory.annotation.EnableDependencyInjection;
import cn.taketoday.beans.factory.config.BeanDefinition;
import cn.taketoday.beans.factory.config.BeanDefinitionHolder;
import cn.taketoday.beans.factory.support.AbstractBeanDefinitionReader;
import cn.taketoday.beans.factory.support.BeanDefinitionReader;
import cn.taketoday.beans.factory.support.BeanDefinitionRegistry;
import cn.taketoday.beans.factory.support.BeanNameGenerator;
import cn.taketoday.beans.factory.support.RootBeanDefinition;
import cn.taketoday.beans.factory.xml.XmlBeanDefinitionReader;
import cn.taketoday.context.BootstrapContext;
import cn.taketoday.context.annotation.AnnotationConfigUtils;
import cn.taketoday.context.annotation.AnnotationScopeMetadataResolver;
import cn.taketoday.context.annotation.BeanAnnotationHelper;
import cn.taketoday.context.annotation.ComponentMethod;
import cn.taketoday.context.annotation.ConfigurationClass;
import cn.taketoday.context.annotation.ConfigurationCondition;
import cn.taketoday.context.annotation.ImportBeanDefinitionRegistrar;
import cn.taketoday.context.annotation.ImportRegistry;
import cn.taketoday.context.annotation.ScannedGenericBeanDefinition;
import cn.taketoday.context.annotation.Scope;
import cn.taketoday.context.annotation.ScopeMetadata;
import cn.taketoday.context.annotation.ScopeMetadataResolver;
import cn.taketoday.context.annotation.ScopedProxyCreator;
import cn.taketoday.context.annotation.ScopedProxyMode;
import cn.taketoday.core.annotation.MergedAnnotation;
import cn.taketoday.core.annotation.MergedAnnotations;
import cn.taketoday.core.io.ResourceLoader;
import cn.taketoday.core.type.AnnotatedTypeMetadata;
import cn.taketoday.core.type.AnnotationMetadata;
import cn.taketoday.core.type.MethodMetadata;
import cn.taketoday.core.type.StandardAnnotationMetadata;
import cn.taketoday.core.type.StandardMethodMetadata;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.NonNull;
import cn.taketoday.logging.Logger;
import cn.taketoday.logging.LoggerFactory;
import cn.taketoday.stereotype.Component;
import cn.taketoday.util.CollectionUtils;
import cn.taketoday.util.ObjectUtils;
import cn.taketoday.util.StringUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

class ConfigurationClassBeanDefinitionReader {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationClassBeanDefinitionReader.class);
    private static final ScopeMetadataResolver scopeMetadataResolver = new AnnotationScopeMetadataResolver();
    private final ImportRegistry importRegistry;
    private final BeanNameGenerator importBeanNameGenerator;
    private final BootstrapContext bootstrapContext;

    ConfigurationClassBeanDefinitionReader(BootstrapContext bootstrapContext, BeanNameGenerator beanNameGenerator, ImportRegistry importRegistry) {
        this.bootstrapContext = bootstrapContext;
        this.importRegistry = importRegistry;
        this.importBeanNameGenerator = beanNameGenerator;
    }

    public void loadBeanDefinitions(Set<ConfigurationClass> configurationModel) {
        TrackedConditionEvaluator trackedConditionEvaluator = new TrackedConditionEvaluator();
        for (ConfigurationClass configClass : configurationModel) {
            this.loadBeanDefinitionsForConfigurationClass(configClass, trackedConditionEvaluator);
        }
    }

    private void loadBeanDefinitionsForConfigurationClass(ConfigurationClass configClass, TrackedConditionEvaluator trackedConditionEvaluator) {
        if (trackedConditionEvaluator.shouldSkip(configClass)) {
            String beanName = configClass.beanName;
            if (StringUtils.isNotEmpty((CharSequence)beanName) && this.bootstrapContext.containsBeanDefinition(beanName)) {
                this.bootstrapContext.removeBeanDefinition(beanName);
            }
            this.importRegistry.removeImportingClass(configClass.metadata.getClassName());
        } else {
            if (configClass.isImported()) {
                this.registerBeanDefinitionForImportedConfigurationClass(configClass);
            }
            for (ComponentMethod componentMethod : configClass.componentMethods) {
                this.loadBeanDefinitionsForComponentMethod(componentMethod);
            }
            this.loadBeanDefinitionsFromImportedResources(configClass.importedResources);
            this.loadBeanDefinitionsFromRegistrars(configClass.importBeanDefinitionRegistrars);
        }
    }

    private void registerBeanDefinitionForImportedConfigurationClass(ConfigurationClass configClass) {
        AnnotatedGenericBeanDefinition configBeanDef = new AnnotatedGenericBeanDefinition(configClass.metadata);
        ScopeMetadata scopeMetadata = scopeMetadataResolver.resolveScopeMetadata((BeanDefinition)configBeanDef);
        configBeanDef.setScope(scopeMetadata.getScopeName());
        String configBeanName = this.importBeanNameGenerator.generateBeanName((BeanDefinition)configBeanDef, this.bootstrapContext.getRegistry());
        AnnotationConfigUtils.processCommonDefinitionAnnotations((AnnotatedBeanDefinition)configBeanDef);
        BeanDefinitionHolder definitionHolder = new BeanDefinitionHolder((BeanDefinition)configBeanDef, configBeanName);
        definitionHolder = AnnotationConfigUtils.applyScopedProxyMode(scopeMetadata, definitionHolder, this.bootstrapContext.getRegistry());
        this.bootstrapContext.registerBeanDefinition(definitionHolder.getBeanName(), definitionHolder.getBeanDefinition());
        configClass.setBeanName(configBeanName);
        if (logger.isTraceEnabled()) {
            logger.trace("Registered bean definition for imported class '{}'", (Object)configBeanName);
        }
    }

    private void loadBeanDefinitionsForComponentMethod(ComponentMethod componentMethod) {
        ConfigurationClassBeanDefinition beanDefToRegister;
        Object[] initMethodName;
        ConfigurationClass configClass = componentMethod.configurationClass;
        MethodMetadata metadata = componentMethod.metadata;
        String methodName = metadata.getMethodName();
        if (this.bootstrapContext.shouldSkip((AnnotatedTypeMetadata)metadata, ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN)) {
            configClass.skippedComponentMethods.add(methodName);
            return;
        }
        if (configClass.skippedComponentMethods.contains(methodName)) {
            return;
        }
        MergedAnnotations annotations = metadata.getAnnotations();
        MergedAnnotation component = annotations.get(Component.class);
        Assert.state((boolean)component.isPresent(), (String)"No @Component annotation attributes");
        ArrayList names = CollectionUtils.newArrayList((Object[])component.getStringArray("name"));
        String beanName = !names.isEmpty() ? (String)names.remove(0) : methodName;
        for (String alias : names) {
            this.bootstrapContext.registerAlias(beanName, alias);
        }
        if (this.isOverriddenByExistingDefinition(componentMethod, beanName)) {
            if (beanName.equals(componentMethod.configurationClass.beanName)) {
                throw new BeanDefinitionStoreException(componentMethod.configurationClass.resource.toString(), beanName, "Bean name derived from @Component method '" + componentMethod.metadata.getMethodName() + "' clashes with bean name for containing configuration class; please make those names unique!");
            }
            return;
        }
        AnnotationMetadata annotationMetadata = configClass.metadata;
        ConfigurationClassBeanDefinition beanDef = new ConfigurationClassBeanDefinition(configClass, metadata, beanName);
        beanDef.setSource(configClass.resource);
        beanDef.setResource(configClass.resource);
        boolean disableDependencyInjectionAll = annotationMetadata.isAnnotated(DisableAllDependencyInjection.class.getName());
        boolean enableDependencyInjection = this.isEnableDependencyInjection(annotations, disableDependencyInjectionAll);
        beanDef.setEnableDependencyInjection(enableDependencyInjection);
        if (metadata.isStatic()) {
            if (annotationMetadata instanceof StandardAnnotationMetadata) {
                beanDef.setBeanClass(((StandardAnnotationMetadata)annotationMetadata).getIntrospectedClass());
            } else {
                beanDef.setBeanClassName(annotationMetadata.getClassName());
            }
            beanDef.setUniqueFactoryMethodName(methodName);
        } else {
            beanDef.setFactoryBeanName(configClass.beanName);
            beanDef.setUniqueFactoryMethodName(methodName);
        }
        if (metadata instanceof StandardMethodMetadata) {
            StandardMethodMetadata sam = (StandardMethodMetadata)metadata;
            beanDef.setResolvedFactoryMethod(sam.getIntrospectedMethod());
        }
        beanDef.setAutowireMode(3);
        AnnotationConfigUtils.processCommonDefinitionAnnotations(beanDef);
        if (!component.getBoolean("autowireCandidate")) {
            beanDef.setAutowireCandidate(false);
        }
        if (ObjectUtils.isNotEmpty((Object[])(initMethodName = component.getStringArray("initMethods")))) {
            beanDef.setInitMethodNames((String[])initMethodName);
        }
        String destroyMethodName = component.getString("destroyMethod");
        beanDef.setDestroyMethodName(destroyMethodName);
        ScopedProxyMode proxyMode = ScopedProxyMode.NO;
        MergedAnnotation scope = annotations.get(Scope.class);
        if (scope.isPresent()) {
            beanDef.setScope(scope.getString("value"));
            proxyMode = (ScopedProxyMode)scope.getEnum("proxyMode", ScopedProxyMode.class);
            if (proxyMode == ScopedProxyMode.DEFAULT) {
                proxyMode = ScopedProxyMode.NO;
            }
        }
        if (proxyMode != ScopedProxyMode.NO) {
            BeanDefinitionHolder proxyDef = ScopedProxyCreator.createScopedProxy(new BeanDefinitionHolder((BeanDefinition)beanDef, beanName), this.bootstrapContext.getRegistry(), proxyMode == ScopedProxyMode.TARGET_CLASS);
            beanDefToRegister = new ConfigurationClassBeanDefinition((RootBeanDefinition)proxyDef.getBeanDefinition(), configClass, metadata, beanName);
        } else {
            beanDefToRegister = beanDef;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Registering bean definition for @Component method {}.{}()", (Object)annotationMetadata.getClassName(), (Object)beanName);
        }
        this.bootstrapContext.registerBeanDefinition(beanName, (BeanDefinition)beanDefToRegister);
    }

    private boolean isEnableDependencyInjection(MergedAnnotations annotations, boolean disableDependencyInjectionAll) {
        return annotations.isPresent(EnableDependencyInjection.class) || !disableDependencyInjectionAll && !annotations.isPresent(DisableDependencyInjection.class);
    }

    protected boolean isOverriddenByExistingDefinition(ComponentMethod componentMethod, String beanName) {
        if (!this.bootstrapContext.containsBeanDefinition(beanName)) {
            return false;
        }
        BeanDefinition existingBeanDef = this.bootstrapContext.getBeanDefinition(beanName);
        if (existingBeanDef == null) {
            return false;
        }
        if (existingBeanDef instanceof ConfigurationClassBeanDefinition) {
            ConfigurationClassBeanDefinition ccbd = (ConfigurationClassBeanDefinition)existingBeanDef;
            if (ccbd.getMetadata().getClassName().equals(componentMethod.configurationClass.metadata.getClassName())) {
                if (ccbd.getFactoryMethodMetadata().getMethodName().equals(ccbd.getFactoryMethodName())) {
                    ccbd.setNonUniqueFactoryMethodName(ccbd.getFactoryMethodMetadata().getMethodName());
                }
                return true;
            }
            return false;
        }
        if (existingBeanDef instanceof ScannedGenericBeanDefinition) {
            return false;
        }
        if (existingBeanDef.getRole() > 0) {
            return false;
        }
        if (!this.bootstrapContext.getRegistry().isAllowBeanDefinitionOverriding()) {
            throw new BeanDefinitionStoreException(componentMethod.configurationClass.resource.toString(), beanName, "@Component definition illegally overridden by existing bean definition: " + existingBeanDef);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Skipping bean definition for {}: a definition for bean '{}' already exists. This top-level bean definition is considered as an override.", (Object)componentMethod, (Object)beanName);
        }
        return true;
    }

    private void loadBeanDefinitionsFromImportedResources(Map<String, Class<? extends BeanDefinitionReader>> importedResources) {
        HashMap<Class<? extends BeanDefinitionReader>, BeanDefinitionReader> readerInstanceCache = new HashMap<Class<? extends BeanDefinitionReader>, BeanDefinitionReader>();
        for (Map.Entry<String, Class<? extends BeanDefinitionReader>> entry : importedResources.entrySet()) {
            BeanDefinitionReader reader;
            String resource = entry.getKey();
            Class<? extends BeanDefinitionReader> readerClass = entry.getValue();
            if (BeanDefinitionReader.class == readerClass) {
                readerClass = XmlBeanDefinitionReader.class;
            }
            if ((reader = (BeanDefinitionReader)readerInstanceCache.get(readerClass)) == null) {
                try {
                    reader = readerClass.getConstructor(BeanDefinitionRegistry.class).newInstance(this.bootstrapContext.getRegistry());
                    if (reader instanceof AbstractBeanDefinitionReader) {
                        AbstractBeanDefinitionReader abdr = (AbstractBeanDefinitionReader)reader;
                        abdr.setEnvironment(this.bootstrapContext.getEnvironment());
                        abdr.setResourceLoader((ResourceLoader)this.bootstrapContext.getResourceLoader());
                    }
                    readerInstanceCache.put(readerClass, reader);
                }
                catch (Throwable ex) {
                    throw new IllegalStateException("Could not instantiate BeanDefinitionReader class [" + readerClass.getName() + "]");
                }
            }
            reader.loadBeanDefinitions(resource);
        }
    }

    private void loadBeanDefinitionsFromRegistrars(Map<ImportBeanDefinitionRegistrar, AnnotationMetadata> registrars) {
        for (Map.Entry<ImportBeanDefinitionRegistrar, AnnotationMetadata> entry : registrars.entrySet()) {
            entry.getKey().registerBeanDefinitions(entry.getValue(), this.bootstrapContext);
        }
    }

    private class TrackedConditionEvaluator {
        private final HashMap<ConfigurationClass, Boolean> skipped = new HashMap();

        private TrackedConditionEvaluator() {
        }

        public boolean shouldSkip(ConfigurationClass configClass) {
            Boolean skip = this.skipped.get(configClass);
            if (skip == null) {
                if (configClass.isImported()) {
                    boolean allSkipped = true;
                    for (ConfigurationClass importedBy : configClass.importedBy) {
                        if (this.shouldSkip(importedBy)) continue;
                        allSkipped = false;
                        break;
                    }
                    if (allSkipped) {
                        skip = true;
                    }
                }
                if (skip == null) {
                    skip = ConfigurationClassBeanDefinitionReader.this.bootstrapContext.shouldSkip((AnnotatedTypeMetadata)configClass.metadata, ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
                }
                this.skipped.put(configClass, skip);
            }
            return skip;
        }
    }

    private static class ConfigurationClassBeanDefinition
    extends RootBeanDefinition
    implements AnnotatedBeanDefinition {
        private final AnnotationMetadata annotationMetadata;
        private final MethodMetadata factoryMethodMetadata;
        private final String derivedBeanName;

        public ConfigurationClassBeanDefinition(ConfigurationClass configClass, MethodMetadata beanMethodMetadata, String derivedBeanName) {
            this.annotationMetadata = configClass.metadata;
            this.factoryMethodMetadata = beanMethodMetadata;
            this.derivedBeanName = derivedBeanName;
            this.setResource(configClass.resource);
            this.setLenientConstructorResolution(false);
        }

        public ConfigurationClassBeanDefinition(RootBeanDefinition original, ConfigurationClass configClass, MethodMetadata beanMethodMetadata, String derivedBeanName) {
            super(original);
            this.annotationMetadata = configClass.metadata;
            this.factoryMethodMetadata = beanMethodMetadata;
            this.derivedBeanName = derivedBeanName;
        }

        private ConfigurationClassBeanDefinition(ConfigurationClassBeanDefinition original) {
            super((RootBeanDefinition)original);
            this.annotationMetadata = original.annotationMetadata;
            this.factoryMethodMetadata = original.factoryMethodMetadata;
            this.derivedBeanName = original.derivedBeanName;
        }

        public AnnotationMetadata getMetadata() {
            return this.annotationMetadata;
        }

        @NonNull
        public MethodMetadata getFactoryMethodMetadata() {
            return this.factoryMethodMetadata;
        }

        public boolean isFactoryMethod(Method candidate) {
            return super.isFactoryMethod(candidate) && BeanAnnotationHelper.isBeanAnnotated(candidate) && BeanAnnotationHelper.determineBeanNameFor(candidate).equals(this.derivedBeanName);
        }

        public ConfigurationClassBeanDefinition cloneBeanDefinition() {
            return new ConfigurationClassBeanDefinition(this);
        }
    }
}

