/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.annotation;

import cn.taketoday.beans.factory.parsing.Location;
import cn.taketoday.beans.factory.parsing.Problem;
import cn.taketoday.beans.factory.parsing.ProblemReporter;
import cn.taketoday.beans.factory.support.BeanDefinitionReader;
import cn.taketoday.context.annotation.ComponentMethod;
import cn.taketoday.context.annotation.Configuration;
import cn.taketoday.context.annotation.ImportBeanDefinitionRegistrar;
import cn.taketoday.core.annotation.MergedAnnotation;
import cn.taketoday.core.io.DescriptiveResource;
import cn.taketoday.core.io.Resource;
import cn.taketoday.core.type.AnnotationMetadata;
import cn.taketoday.core.type.classreading.MetadataReader;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.ClassUtils;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;

final class ConfigurationClass {
    public final AnnotationMetadata metadata;
    public final Resource resource;
    @Nullable
    public String beanName;
    public final LinkedHashSet<ConfigurationClass> importedBy = new LinkedHashSet(1);
    public final LinkedHashSet<ComponentMethod> componentMethods = new LinkedHashSet();
    public final Map<ImportBeanDefinitionRegistrar, AnnotationMetadata> importBeanDefinitionRegistrars = new LinkedHashMap<ImportBeanDefinitionRegistrar, AnnotationMetadata>();
    public final Map<String, Class<? extends BeanDefinitionReader>> importedResources = new LinkedHashMap<String, Class<? extends BeanDefinitionReader>>();
    final HashSet<String> skippedComponentMethods = new HashSet();

    ConfigurationClass(MetadataReader metadataReader, @Nullable String beanName) {
        this.metadata = metadataReader.getAnnotationMetadata();
        this.resource = metadataReader.getResource();
        this.beanName = beanName;
    }

    ConfigurationClass(MetadataReader metadataReader, @Nullable ConfigurationClass importedBy) {
        this.metadata = metadataReader.getAnnotationMetadata();
        this.resource = metadataReader.getResource();
        this.importedBy.add(importedBy);
    }

    ConfigurationClass(Class<?> clazz, @Nullable String beanName) {
        this.metadata = AnnotationMetadata.introspect(clazz);
        this.resource = new DescriptiveResource(clazz.getName());
        this.beanName = beanName;
    }

    ConfigurationClass(Class<?> clazz, @Nullable ConfigurationClass importedBy) {
        this.metadata = AnnotationMetadata.introspect(clazz);
        this.resource = new DescriptiveResource(clazz.getName());
        this.importedBy.add(importedBy);
    }

    ConfigurationClass(AnnotationMetadata metadata, @Nullable String beanName) {
        this.metadata = metadata;
        this.resource = new DescriptiveResource(metadata.getClassName());
        this.beanName = beanName;
    }

    String getSimpleName() {
        return ClassUtils.getShortName((String)this.metadata.getClassName());
    }

    void setBeanName(@Nullable String beanName) {
        this.beanName = beanName;
    }

    public boolean isImported() {
        return !this.importedBy.isEmpty();
    }

    void mergeImportedBy(ConfigurationClass otherConfigClass) {
        this.importedBy.addAll(otherConfigClass.importedBy);
    }

    void addMethod(ComponentMethod method) {
        this.componentMethods.add(method);
    }

    void addImportBeanDefinitionRegistrar(ImportBeanDefinitionRegistrar registrar, AnnotationMetadata importingClassMetadata) {
        this.importBeanDefinitionRegistrars.put(registrar, importingClassMetadata);
    }

    void addImportedResource(String importedResource, Class<? extends BeanDefinitionReader> readerClass) {
        this.importedResources.put(importedResource, readerClass);
    }

    void validate(ProblemReporter problemReporter) {
        MergedAnnotation annotation = this.metadata.getAnnotation(Configuration.class);
        if (annotation.isPresent() && annotation.getValue("proxyBeanMethods", Boolean.TYPE).orElse(true).booleanValue()) {
            if (this.metadata.isFinal()) {
                problemReporter.error((Problem)new FinalConfigurationProblem());
            }
            for (ComponentMethod componentMethod : this.componentMethods) {
                componentMethod.validate(problemReporter);
            }
        }
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof ConfigurationClass && this.metadata.getClassName().equals(((ConfigurationClass)other).metadata.getClassName());
    }

    public int hashCode() {
        return this.metadata.getClassName().hashCode();
    }

    public String toString() {
        return "ConfigurationClass: beanName '" + this.beanName + "', " + this.resource;
    }

    private class FinalConfigurationProblem
    extends Problem {
        FinalConfigurationProblem() {
            super(String.format("@Configuration class '%s' may not be final, when proxyBeanMethods is enabled. Remove the final modifier to continue.", ConfigurationClass.this.getSimpleName()), new Location(ConfigurationClass.this.resource, (Object)ConfigurationClass.this.metadata));
        }
    }
}

