/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.annotation;

import cn.taketoday.beans.BeanUtils;
import cn.taketoday.beans.factory.support.BeanDefinitionRegistry;
import cn.taketoday.context.ApplicationContext;
import cn.taketoday.context.annotation.Condition;
import cn.taketoday.context.annotation.ConditionContext;
import cn.taketoday.context.annotation.Conditional;
import cn.taketoday.context.annotation.ConfigurationClassUtils;
import cn.taketoday.context.annotation.ConfigurationCondition;
import cn.taketoday.core.annotation.AnnotationAwareOrderComparator;
import cn.taketoday.core.env.Environment;
import cn.taketoday.core.io.ResourceLoader;
import cn.taketoday.core.type.AnnotatedTypeMetadata;
import cn.taketoday.core.type.AnnotationMetadata;
import cn.taketoday.core.type.StandardMethodMetadata;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.ClassUtils;
import cn.taketoday.util.MultiValueMap;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ConditionEvaluator {
    private final ConditionContext evaluationContext;

    public ConditionEvaluator(ApplicationContext context, BeanDefinitionRegistry registry) {
        this.evaluationContext = new ConditionContext(context, registry);
    }

    public ConditionEvaluator(@Nullable Environment environment, @Nullable ResourceLoader resourceLoader, @Nullable BeanDefinitionRegistry registry) {
        this.evaluationContext = new ConditionContext(registry, environment, resourceLoader);
    }

    public boolean passCondition(AnnotatedTypeMetadata metadata) {
        return this.passCondition(metadata, null);
    }

    public boolean passCondition(Class<?> annotated) {
        AnnotationMetadata introspect = AnnotationMetadata.introspect(annotated);
        return this.passCondition((AnnotatedTypeMetadata)introspect);
    }

    public boolean passCondition(Method annotated) {
        StandardMethodMetadata standardMethodMetadata = new StandardMethodMetadata(annotated);
        return this.passCondition((AnnotatedTypeMetadata)standardMethodMetadata);
    }

    public boolean passCondition(AnnotatedTypeMetadata metadata, @Nullable ConfigurationCondition.ConfigurationPhase phase) {
        return !this.shouldSkip(metadata, phase);
    }

    public boolean shouldSkip(AnnotatedTypeMetadata metadata) {
        return this.shouldSkip(metadata, null);
    }

    public boolean shouldSkip(@Nullable AnnotatedTypeMetadata metadata, @Nullable ConfigurationCondition.ConfigurationPhase phase) {
        if (metadata == null || !metadata.isAnnotated(Conditional.class.getName())) {
            return false;
        }
        if (phase == null) {
            if (metadata instanceof AnnotationMetadata && ConfigurationClassUtils.isConfigurationCandidate((AnnotationMetadata)metadata)) {
                return this.shouldSkip(metadata, ConfigurationCondition.ConfigurationPhase.PARSE_CONFIGURATION);
            }
            return this.shouldSkip(metadata, ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        ClassLoader classLoader = this.evaluationContext.getClassLoader();
        for (String[] conditionClasses : this.getConditionClasses(metadata)) {
            for (String conditionClass : conditionClasses) {
                Condition condition = this.getCondition(conditionClass, classLoader);
                conditions.add(condition);
            }
        }
        AnnotationAwareOrderComparator.sort(conditions);
        for (Condition condition : conditions) {
            ConfigurationCondition.ConfigurationPhase requiredPhase = null;
            if (condition instanceof ConfigurationCondition) {
                requiredPhase = ((ConfigurationCondition)condition).getConfigurationPhase();
            }
            if (requiredPhase != null && requiredPhase != phase || condition.matches(this.evaluationContext, metadata)) continue;
            return true;
        }
        return false;
    }

    private List<String[]> getConditionClasses(AnnotatedTypeMetadata metadata) {
        MultiValueMap attributes = metadata.getAllAnnotationAttributes(Conditional.class.getName(), true);
        List<String[]> values = attributes != null ? attributes.get((Object)"value") : null;
        return values != null ? values : Collections.emptyList();
    }

    private Condition getCondition(String conditionClassName, @Nullable ClassLoader classloader) {
        Class conditionClass = ClassUtils.resolveClassName((String)conditionClassName, (ClassLoader)classloader);
        return (Condition)BeanUtils.newInstance((Class)conditionClass);
    }
}

