/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.annotation;

import cn.taketoday.beans.factory.config.ConfigurableBeanFactory;
import cn.taketoday.beans.factory.support.BeanDefinitionRegistry;
import cn.taketoday.context.ApplicationContext;
import cn.taketoday.context.ConfigurableApplicationContext;
import cn.taketoday.core.env.Environment;
import cn.taketoday.core.env.EnvironmentCapable;
import cn.taketoday.core.env.StandardEnvironment;
import cn.taketoday.core.io.DefaultResourceLoader;
import cn.taketoday.core.io.ResourceLoader;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.ClassUtils;

public class ConditionContext {
    @Nullable
    private final BeanDefinitionRegistry registry;
    @Nullable
    private final ConfigurableBeanFactory beanFactory;
    private final Environment environment;
    private final ResourceLoader resourceLoader;
    private final ClassLoader classLoader;

    public ConditionContext(ApplicationContext context, @Nullable BeanDefinitionRegistry registry) {
        this.registry = registry;
        this.resourceLoader = context;
        this.environment = context.getEnvironment();
        this.beanFactory = this.deduceBeanFactory(registry);
        this.classLoader = this.deduceClassLoader(this.resourceLoader, this.beanFactory);
    }

    public ConditionContext(@Nullable BeanDefinitionRegistry registry, @Nullable Environment environment, @Nullable ResourceLoader resourceLoader) {
        this.registry = registry;
        this.beanFactory = this.deduceBeanFactory(registry);
        this.environment = environment != null ? environment : this.deduceEnvironment(registry);
        this.resourceLoader = resourceLoader != null ? resourceLoader : this.deduceResourceLoader(registry);
        this.classLoader = this.deduceClassLoader(resourceLoader, this.beanFactory);
    }

    @Nullable
    private ConfigurableBeanFactory deduceBeanFactory(@Nullable BeanDefinitionRegistry source) {
        if (source instanceof ConfigurableBeanFactory) {
            return (ConfigurableBeanFactory)source;
        }
        if (source instanceof ConfigurableApplicationContext) {
            return ((ConfigurableApplicationContext)source).getBeanFactory();
        }
        return null;
    }

    private Environment deduceEnvironment(@Nullable BeanDefinitionRegistry source) {
        if (source instanceof EnvironmentCapable) {
            return ((EnvironmentCapable)source).getEnvironment();
        }
        return new StandardEnvironment();
    }

    private ResourceLoader deduceResourceLoader(@Nullable BeanDefinitionRegistry source) {
        if (source instanceof ResourceLoader) {
            return (ResourceLoader)source;
        }
        return new DefaultResourceLoader();
    }

    @Nullable
    private ClassLoader deduceClassLoader(@Nullable ResourceLoader resourceLoader, @Nullable ConfigurableBeanFactory beanFactory) {
        ClassLoader classLoader;
        if (resourceLoader != null && (classLoader = resourceLoader.getClassLoader()) != null) {
            return classLoader;
        }
        if (beanFactory != null) {
            return beanFactory.getBeanClassLoader();
        }
        return ClassUtils.getDefaultClassLoader();
    }

    public BeanDefinitionRegistry getRegistry() {
        Assert.state((this.registry != null ? 1 : 0) != 0, (String)"No BeanDefinitionRegistry available");
        return this.registry;
    }

    @Nullable
    public ConfigurableBeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public ConfigurableBeanFactory getRequiredBeanFactory() {
        ConfigurableBeanFactory beanFactory = this.getBeanFactory();
        Assert.state((beanFactory != null ? 1 : 0) != 0, (String)"No BeanFactory available");
        return beanFactory;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }
}

