/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.annotation;

import cn.taketoday.beans.BeanUtils;
import cn.taketoday.beans.factory.config.BeanDefinitionHolder;
import cn.taketoday.beans.factory.support.BeanNameGenerator;
import cn.taketoday.context.BootstrapContext;
import cn.taketoday.context.annotation.ClassPathBeanDefinitionScanner;
import cn.taketoday.context.annotation.ComponentScan;
import cn.taketoday.context.annotation.ScopeMetadataResolver;
import cn.taketoday.context.annotation.ScopedProxyMode;
import cn.taketoday.context.annotation.TypeFilterUtils;
import cn.taketoday.core.annotation.MergedAnnotation;
import cn.taketoday.core.type.filter.AbstractTypeHierarchyTraversingFilter;
import cn.taketoday.core.type.filter.TypeFilter;
import cn.taketoday.util.ClassUtils;
import cn.taketoday.util.StringUtils;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

class ComponentScanAnnotationParser {
    private final BootstrapContext context;

    public ComponentScanAnnotationParser(BootstrapContext bootstrapContext) {
        this.context = bootstrapContext;
    }

    public Set<BeanDefinitionHolder> parse(MergedAnnotation<ComponentScan> componentScan, final String declaringClass) {
        List<TypeFilter> typeFilters;
        ClassPathBeanDefinitionScanner scanner = new ClassPathBeanDefinitionScanner(this.context.getRegistry(), componentScan.getBoolean("useDefaultFilters"), this.context.getEnvironment());
        Class generatorClass = componentScan.getClass("nameGenerator");
        boolean useInheritedPopulator = BeanNameGenerator.class == generatorClass;
        scanner.setBeanNameGenerator(useInheritedPopulator ? this.context.getBeanNameGenerator() : (BeanNameGenerator)BeanUtils.newInstance((Class)generatorClass));
        ScopedProxyMode scopedProxyMode = (ScopedProxyMode)componentScan.getEnum("scopedProxy", ScopedProxyMode.class);
        if (scopedProxyMode != ScopedProxyMode.DEFAULT) {
            scanner.setScopedProxyMode(scopedProxyMode);
        } else {
            MergedAnnotation[] resolverClass = componentScan.getClass("scopeResolver");
            if (resolverClass != ScopeMetadataResolver.class) {
                scanner.setScopeMetadataResolver((ScopeMetadataResolver)BeanUtils.newInstance((Class)resolverClass));
            }
        }
        scanner.setResourcePattern(componentScan.getString("resourcePattern"));
        for (MergedAnnotation includeFilter : componentScan.getAnnotationArray("includeFilters", ComponentScan.Filter.class)) {
            typeFilters = TypeFilterUtils.createTypeFiltersFor((MergedAnnotation<ComponentScan.Filter>)includeFilter, this.context);
            for (TypeFilter typeFilter : typeFilters) {
                scanner.addIncludeFilter(typeFilter);
            }
        }
        for (MergedAnnotation excludeFilter : componentScan.getAnnotationArray("excludeFilters", ComponentScan.Filter.class)) {
            typeFilters = TypeFilterUtils.createTypeFiltersFor((MergedAnnotation<ComponentScan.Filter>)excludeFilter, this.context);
            for (TypeFilter typeFilter : typeFilters) {
                scanner.addExcludeFilter(typeFilter);
            }
        }
        boolean lazyInit = componentScan.getBoolean("lazyInit");
        if (lazyInit) {
            scanner.getBeanDefinitionDefaults().setLazyInit(true);
        }
        LinkedHashSet<String> basePackages = new LinkedHashSet<String>();
        String[] basePackagesArray = componentScan.getStringArray("basePackages");
        for (String pkg : basePackagesArray) {
            String[] tokenized = StringUtils.tokenizeToStringArray((String)this.context.evaluateExpression(pkg), (String)",; \t\n");
            Collections.addAll(basePackages, tokenized);
        }
        for (Class clazz : componentScan.getClassArray("basePackageClasses")) {
            basePackages.add(ClassUtils.getPackageName((Class)clazz));
        }
        if (basePackages.isEmpty()) {
            basePackages.add(ClassUtils.getPackageName((String)declaringClass));
        }
        scanner.addExcludeFilter((TypeFilter)new AbstractTypeHierarchyTraversingFilter(false, false){

            protected boolean matchClassName(String className) {
                return declaringClass.equals(className);
            }
        });
        return scanner.collectHolders(StringUtils.toStringArray(basePackages));
    }
}

