/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.annotation;

import cn.taketoday.beans.factory.parsing.Location;
import cn.taketoday.beans.factory.parsing.Problem;
import cn.taketoday.beans.factory.parsing.ProblemReporter;
import cn.taketoday.context.annotation.Configuration;
import cn.taketoday.context.annotation.ConfigurationClass;
import cn.taketoday.core.type.MethodMetadata;
import cn.taketoday.lang.Nullable;

final class ComponentMethod {
    public final MethodMetadata metadata;
    public final ConfigurationClass configurationClass;

    public ComponentMethod(MethodMetadata metadata, ConfigurationClass configurationClass) {
        this.metadata = metadata;
        this.configurationClass = configurationClass;
    }

    public Location getResourceLocation() {
        return new Location(this.configurationClass.resource, (Object)this.metadata);
    }

    public void validate(ProblemReporter problemReporter) {
        if (this.metadata.isStatic()) {
            return;
        }
        if (this.configurationClass.metadata.isAnnotated(Configuration.class.getName()) && !this.metadata.isOverridable()) {
            problemReporter.error((Problem)new NonOverridableMethodError());
        }
    }

    public boolean equals(@Nullable Object obj) {
        return this == obj || obj instanceof ComponentMethod && this.metadata.equals(((ComponentMethod)obj).metadata);
    }

    public int hashCode() {
        return this.metadata.hashCode();
    }

    public String toString() {
        return "ComponentMethod: " + this.metadata;
    }

    private class NonOverridableMethodError
    extends Problem {
        NonOverridableMethodError() {
            super(String.format("@Component method '%s' must not be private or final; change the method's modifiers to continue", ComponentMethod.this.metadata.getMethodName()), ComponentMethod.this.getResourceLocation());
        }
    }
}

