/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.annotation;

import cn.taketoday.context.ResourceLoaderAware;
import cn.taketoday.context.annotation.MetadataReaderConsumer;
import cn.taketoday.core.io.PathMatchingPatternResourceLoader;
import cn.taketoday.core.io.PatternResourceLoader;
import cn.taketoday.core.io.ResourceLoader;
import cn.taketoday.core.type.classreading.CachingMetadataReaderFactory;
import cn.taketoday.core.type.classreading.MetadataReader;
import cn.taketoday.core.type.classreading.MetadataReaderFactory;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.logging.Logger;
import cn.taketoday.logging.LoggerFactory;
import cn.taketoday.util.ClassUtils;
import java.io.FileNotFoundException;
import java.io.IOException;

public class ClassPathScanningComponentProvider
implements ResourceLoaderAware {
    private static final Logger log = LoggerFactory.getLogger(ClassPathScanningComponentProvider.class);
    public static final String DEFAULT_RESOURCE_PATTERN = "**/*.class";
    private String resourcePattern = "**/*.class";
    private String resourcePrefix = "classpath*:";
    @Nullable
    protected PatternResourceLoader resourcePatternResolver;
    @Nullable
    private MetadataReaderFactory metadataReaderFactory;

    public void setResourcePattern(String resourcePattern) {
        Assert.notNull((Object)resourcePattern, (String)"'resourcePattern' must not be null");
        this.resourcePattern = resourcePattern;
    }

    public void setResourcePrefix(String resourcePrefix) {
        Assert.notNull((Object)resourcePrefix, (String)"'resourcePrefix' is required");
        this.resourcePrefix = resourcePrefix;
    }

    public String getResourcePrefix() {
        return this.resourcePrefix;
    }

    @Override
    public void setResourceLoader(@Nullable ResourceLoader resourceLoader) {
        this.resourcePatternResolver = PatternResourceLoader.fromResourceLoader((ResourceLoader)resourceLoader);
        this.metadataReaderFactory = new CachingMetadataReaderFactory(resourceLoader);
    }

    public final PatternResourceLoader getResourceLoader() {
        if (this.resourcePatternResolver == null) {
            this.resourcePatternResolver = new PathMatchingPatternResourceLoader();
        }
        return this.resourcePatternResolver;
    }

    public void setMetadataReaderFactory(@Nullable MetadataReaderFactory metadataReaderFactory) {
        this.metadataReaderFactory = metadataReaderFactory;
    }

    public final MetadataReaderFactory getMetadataReaderFactory() {
        if (this.metadataReaderFactory == null) {
            this.metadataReaderFactory = new CachingMetadataReaderFactory();
        }
        return this.metadataReaderFactory;
    }

    public void scan(String basePackage, MetadataReaderConsumer metadataReaderConsumer) throws IOException {
        boolean traceEnabled = log.isTraceEnabled();
        String packageSearchPath = this.getPatternLocation(basePackage);
        this.getResourceLoader().scan(packageSearchPath, resource -> {
            block3: {
                if (traceEnabled) {
                    log.trace("Scanning {}", (Object)resource);
                }
                try {
                    MetadataReaderFactory factory = this.getMetadataReaderFactory();
                    MetadataReader metadataReader = factory.getMetadataReader(resource);
                    metadataReaderConsumer.accept(metadataReader, factory);
                }
                catch (FileNotFoundException ex) {
                    if (!traceEnabled) break block3;
                    log.trace("Ignored non-readable {}: {}", (Object)resource, (Object)ex.getMessage());
                }
            }
        });
    }

    protected String getPatternLocation(String input) {
        return this.resourcePrefix + this.resolveBasePackage(input) + "/" + this.resourcePattern;
    }

    protected String resolveBasePackage(String basePackage) {
        return ClassUtils.convertClassNameToResourcePath((String)basePackage);
    }

    public void clearCache() {
        if (this.metadataReaderFactory instanceof CachingMetadataReaderFactory) {
            ((CachingMetadataReaderFactory)this.metadataReaderFactory).clearCache();
        }
    }
}

