/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.annotation;

import cn.taketoday.beans.factory.BeanDefinitionStoreException;
import cn.taketoday.beans.factory.annotation.AnnotatedBeanDefinition;
import cn.taketoday.beans.factory.annotation.Lookup;
import cn.taketoday.beans.factory.support.BeanDefinitionRegistry;
import cn.taketoday.context.annotation.ClassPathScanningComponentProvider;
import cn.taketoday.context.annotation.ConditionEvaluator;
import cn.taketoday.context.annotation.MetadataReaderConsumer;
import cn.taketoday.context.annotation.ScannedGenericBeanDefinition;
import cn.taketoday.context.index.CandidateComponentsIndex;
import cn.taketoday.context.index.CandidateComponentsIndexLoader;
import cn.taketoday.core.annotation.AnnotationUtils;
import cn.taketoday.core.env.Environment;
import cn.taketoday.core.env.EnvironmentCapable;
import cn.taketoday.core.env.StandardEnvironment;
import cn.taketoday.core.io.ResourceLoader;
import cn.taketoday.core.type.AnnotatedTypeMetadata;
import cn.taketoday.core.type.AnnotationMetadata;
import cn.taketoday.core.type.classreading.MetadataReader;
import cn.taketoday.core.type.classreading.MetadataReaderFactory;
import cn.taketoday.core.type.filter.AnnotationTypeFilter;
import cn.taketoday.core.type.filter.AssignableTypeFilter;
import cn.taketoday.core.type.filter.TypeFilter;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.logging.Logger;
import cn.taketoday.logging.LoggerFactory;
import cn.taketoday.stereotype.Component;
import cn.taketoday.stereotype.Indexed;
import cn.taketoday.util.ClassUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Predicate;

public class ClassPathScanningCandidateComponentProvider
extends ClassPathScanningComponentProvider
implements EnvironmentCapable {
    private static final Logger log = LoggerFactory.getLogger(ClassPathScanningCandidateComponentProvider.class);
    private final ArrayList<TypeFilter> includeFilters = new ArrayList();
    private final ArrayList<TypeFilter> excludeFilters = new ArrayList();
    @Nullable
    private Environment environment;
    @Nullable
    private ConditionEvaluator conditionEvaluator;
    @Nullable
    private CandidateComponentsIndex componentsIndex;
    private Predicate<AnnotationMetadata> candidateComponentPredicate = this::isCandidateComponent;

    public ClassPathScanningCandidateComponentProvider() {
    }

    public ClassPathScanningCandidateComponentProvider(boolean useDefaultFilters) {
        this(useDefaultFilters, (Environment)new StandardEnvironment());
    }

    public ClassPathScanningCandidateComponentProvider(boolean useDefaultFilters, Environment environment) {
        if (useDefaultFilters) {
            this.registerDefaultFilters();
        }
        this.setEnvironment(environment);
        this.setResourceLoader(null);
    }

    public void addIncludeFilter(TypeFilter includeFilter) {
        this.includeFilters.add(includeFilter);
    }

    public void addExcludeFilter(TypeFilter excludeFilter) {
        this.excludeFilters.add(0, excludeFilter);
    }

    public void resetFilters(boolean useDefaultFilters) {
        this.includeFilters.clear();
        this.excludeFilters.clear();
        if (useDefaultFilters) {
            this.registerDefaultFilters();
        }
    }

    protected void registerDefaultFilters() {
        this.includeFilters.add((TypeFilter)new AnnotationTypeFilter(Component.class));
        ClassLoader cl = ClassPathScanningCandidateComponentProvider.class.getClassLoader();
        try {
            this.includeFilters.add((TypeFilter)new AnnotationTypeFilter(ClassUtils.forName((String)"jakarta.annotation.ManagedBean", (ClassLoader)cl), false));
            log.trace("JSR-250 'jakarta.annotation.ManagedBean' found and supported for component scanning");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            this.includeFilters.add((TypeFilter)new AnnotationTypeFilter(ClassUtils.forName((String)"jakarta.inject.Named", (ClassLoader)cl), false));
            log.trace("JSR-330 'jakarta.inject.Named' annotation found and supported for component scanning");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public void setEnvironment(Environment environment) {
        Assert.notNull((Object)environment, (String)"Environment must not be null");
        this.environment = environment;
        this.conditionEvaluator = null;
    }

    public final Environment getEnvironment() {
        if (this.environment == null) {
            this.environment = new StandardEnvironment();
        }
        return this.environment;
    }

    @Nullable
    protected BeanDefinitionRegistry getRegistry() {
        return null;
    }

    @Override
    public void setResourceLoader(@Nullable ResourceLoader resourceLoader) {
        super.setResourceLoader(resourceLoader);
        this.componentsIndex = CandidateComponentsIndexLoader.loadIndex(this.getResourceLoader().getClassLoader());
    }

    public void setCandidateComponentPredicate(@Nullable Predicate<AnnotationMetadata> candidateComponentPredicate) {
        this.candidateComponentPredicate = candidateComponentPredicate == null ? this::isCandidateComponent : candidateComponentPredicate;
    }

    public Set<AnnotatedBeanDefinition> findCandidateComponents(String basePackage) {
        try {
            LinkedHashSet<AnnotatedBeanDefinition> candidates = new LinkedHashSet<AnnotatedBeanDefinition>();
            this.scanCandidateComponents(basePackage, (metadataReader, metadataReaderFactory) -> {
                ScannedGenericBeanDefinition sbd = new ScannedGenericBeanDefinition(metadataReader);
                sbd.setSource(metadataReader.getResource());
                candidates.add(sbd);
            });
            return candidates;
        }
        catch (IOException ex) {
            throw new BeanDefinitionStoreException("I/O failure during classpath scanning", (Throwable)ex);
        }
    }

    public void scanCandidateComponents(String basePackage, MetadataReaderConsumer metadataReaderConsumer) throws IOException {
        if (this.componentsIndex != null && this.indexSupportsIncludeFilters()) {
            this.scanCandidateComponentsFromIndex(this.componentsIndex, basePackage, new FilteredMetadataReaderConsumer(metadataReaderConsumer));
        } else {
            this.scan(basePackage, new FilteredMetadataReaderConsumer(metadataReaderConsumer));
        }
    }

    private boolean indexSupportsIncludeFilters() {
        for (TypeFilter includeFilter : this.includeFilters) {
            if (this.indexSupportsIncludeFilter(includeFilter)) continue;
            return false;
        }
        return true;
    }

    private boolean indexSupportsIncludeFilter(TypeFilter filter) {
        if (filter instanceof AnnotationTypeFilter) {
            Class annotation = ((AnnotationTypeFilter)filter).getAnnotationType();
            return AnnotationUtils.isAnnotationDeclaredLocally(Indexed.class, (Class)annotation) || annotation.getName().startsWith("jakarta.");
        }
        if (filter instanceof AssignableTypeFilter) {
            Class target = ((AssignableTypeFilter)filter).getTargetType();
            return AnnotationUtils.isAnnotationDeclaredLocally(Indexed.class, (Class)target);
        }
        return false;
    }

    @Nullable
    private String extractStereotype(TypeFilter filter) {
        if (filter instanceof AnnotationTypeFilter) {
            return ((AnnotationTypeFilter)filter).getAnnotationType().getName();
        }
        if (filter instanceof AssignableTypeFilter) {
            return ((AssignableTypeFilter)filter).getTargetType().getName();
        }
        return null;
    }

    private void scanCandidateComponentsFromIndex(CandidateComponentsIndex index, String basePackage, MetadataReaderConsumer metadataReaderConsumer) throws IOException {
        HashSet<String> types = new HashSet<String>();
        for (TypeFilter filter : this.includeFilters) {
            String stereotype = this.extractStereotype(filter);
            if (stereotype == null) {
                throw new IllegalArgumentException("Failed to extract stereotype from " + filter);
            }
            types.addAll(index.getCandidateTypes(basePackage, stereotype));
        }
        MetadataReaderFactory metadataReaderFactory = this.getMetadataReaderFactory();
        for (String type : types) {
            MetadataReader metadataReader = metadataReaderFactory.getMetadataReader(type);
            metadataReaderConsumer.accept(metadataReader, metadataReaderFactory);
        }
    }

    @Override
    protected String resolveBasePackage(String basePackage) {
        return ClassUtils.convertClassNameToResourcePath((String)this.getEnvironment().resolveRequiredPlaceholders(basePackage));
    }

    protected boolean isCandidateComponent(MetadataReader metadataReader, MetadataReaderFactory factory) throws IOException {
        for (TypeFilter tf : this.excludeFilters) {
            if (!tf.match(metadataReader, factory)) continue;
            return false;
        }
        for (TypeFilter tf : this.includeFilters) {
            if (!tf.match(metadataReader, factory)) continue;
            return this.isConditionMatch(metadataReader);
        }
        return false;
    }

    private boolean isConditionMatch(MetadataReader metadataReader) {
        if (this.conditionEvaluator == null) {
            this.conditionEvaluator = new ConditionEvaluator(this.environment, (ResourceLoader)this.getResourceLoader(), this.getRegistry());
        }
        return this.conditionEvaluator.passCondition((AnnotatedTypeMetadata)metadataReader.getAnnotationMetadata());
    }

    protected boolean isCandidateComponent(AnnotationMetadata metadata) {
        return metadata.isIndependent() && (metadata.isConcrete() || metadata.isAbstract() && metadata.hasAnnotatedMethods(Lookup.class.getName()));
    }

    class FilteredMetadataReaderConsumer
    implements MetadataReaderConsumer {
        final MetadataReaderConsumer metadataReaderConsumer;

        FilteredMetadataReaderConsumer(MetadataReaderConsumer metadataReaderConsumer) {
            this.metadataReaderConsumer = metadataReaderConsumer;
        }

        @Override
        public void accept(MetadataReader metadataReader, MetadataReaderFactory factory) throws IOException {
            if (ClassPathScanningCandidateComponentProvider.this.isCandidateComponent(metadataReader, factory) && ClassPathScanningCandidateComponentProvider.this.candidateComponentPredicate.test(metadataReader.getAnnotationMetadata())) {
                this.metadataReaderConsumer.accept(metadataReader, factory);
            }
        }
    }
}

