/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.annotation;

import cn.taketoday.context.annotation.Scope;
import cn.taketoday.context.annotation.ScopedProxyMode;
import cn.taketoday.core.annotation.AnnotatedElementUtils;
import cn.taketoday.core.annotation.AnnotationAttributes;
import cn.taketoday.stereotype.Component;
import cn.taketoday.util.ConcurrentReferenceHashMap;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;

abstract class BeanAnnotationHelper {
    private static final ConcurrentReferenceHashMap<Method, String> beanNameCache = new ConcurrentReferenceHashMap();
    private static final ConcurrentReferenceHashMap<Method, Boolean> scopedProxyCache = new ConcurrentReferenceHashMap();

    BeanAnnotationHelper() {
    }

    public static boolean isBeanAnnotated(Method method) {
        return AnnotatedElementUtils.hasAnnotation((AnnotatedElement)method, Component.class);
    }

    public static String determineBeanNameFor(Method beanMethod) {
        String beanName = (String)beanNameCache.get((Object)beanMethod);
        if (beanName == null) {
            String[] names;
            beanName = beanMethod.getName();
            AnnotationAttributes bean = AnnotatedElementUtils.findMergedAnnotationAttributes((AnnotatedElement)beanMethod, Component.class, (boolean)false, (boolean)false);
            if (bean != null && (names = bean.getStringArray("name")).length > 0) {
                beanName = names[0];
            }
            beanNameCache.put((Object)beanMethod, (Object)beanName);
        }
        return beanName;
    }

    public static boolean isScopedProxy(Method beanMethod) {
        Boolean scopedProxy = (Boolean)scopedProxyCache.get((Object)beanMethod);
        if (scopedProxy == null) {
            AnnotationAttributes scope = AnnotatedElementUtils.findMergedAnnotationAttributes((AnnotatedElement)beanMethod, Scope.class, (boolean)false, (boolean)false);
            scopedProxy = scope != null && scope.getEnum("proxyMode") != ScopedProxyMode.NO;
            scopedProxyCache.put((Object)beanMethod, (Object)scopedProxy);
        }
        return scopedProxy;
    }
}

