/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.annotation;

import cn.taketoday.aop.config.AopConfigUtils;
import cn.taketoday.beans.factory.support.BeanDefinitionRegistry;
import cn.taketoday.context.BootstrapContext;
import cn.taketoday.context.annotation.AdviceMode;
import cn.taketoday.context.annotation.ImportBeanDefinitionRegistrar;
import cn.taketoday.core.annotation.AnnotationAttributes;
import cn.taketoday.core.type.AnnotatedTypeMetadata;
import cn.taketoday.core.type.AnnotationMetadata;
import cn.taketoday.logging.Logger;
import cn.taketoday.logging.LoggerFactory;
import java.util.Set;

public class AutoProxyRegistrar
implements ImportBeanDefinitionRegistrar {
    private static final Logger log = LoggerFactory.getLogger(AutoProxyRegistrar.class);

    @Override
    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BootstrapContext context) {
        boolean candidateFound = false;
        Set annTypes = importingClassMetadata.getAnnotationTypes();
        for (String annType : annTypes) {
            AnnotationAttributes candidate = AnnotationAttributes.fromMetadata((AnnotatedTypeMetadata)importingClassMetadata, (String)annType);
            if (candidate == null) continue;
            Object mode = candidate.get((Object)"mode");
            Object proxyTargetClass = candidate.get((Object)"proxyTargetClass");
            if (mode == null || proxyTargetClass == null || AdviceMode.class != mode.getClass() || Boolean.class != proxyTargetClass.getClass()) continue;
            candidateFound = true;
            if (mode != AdviceMode.PROXY) continue;
            AopConfigUtils.registerAutoProxyCreatorIfNecessary((BeanDefinitionRegistry)context.getRegistry());
            if (!((Boolean)proxyTargetClass).booleanValue()) continue;
            AopConfigUtils.forceAutoProxyCreatorToUseClassProxying((BeanDefinitionRegistry)context.getRegistry());
            return;
        }
        if (!candidateFound && log.isInfoEnabled()) {
            String name = this.getClass().getSimpleName();
            log.info(String.format("%s was imported but no annotations were found having both 'mode' and 'proxyTargetClass' attributes of type AdviceMode and boolean respectively. This means that auto proxy creator registration and configuration may not have occurred as intended, and components may not be proxied as expected. Check to ensure that %s has been @Import'ed on the same class where these annotations are declared; otherwise remove the import of %s altogether.", name, name, name));
        }
    }
}

