/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.annotation;

import cn.taketoday.beans.factory.annotation.AnnotatedBeanDefinition;
import cn.taketoday.beans.factory.config.BeanDefinition;
import cn.taketoday.context.annotation.Scope;
import cn.taketoday.context.annotation.ScopeMetadata;
import cn.taketoday.context.annotation.ScopeMetadataResolver;
import cn.taketoday.context.annotation.ScopedProxyMode;
import cn.taketoday.core.annotation.MergedAnnotation;
import cn.taketoday.core.type.MethodMetadata;
import cn.taketoday.lang.Assert;
import java.lang.annotation.Annotation;
import java.util.Optional;

public class AnnotationScopeMetadataResolver
implements ScopeMetadataResolver {
    private final ScopedProxyMode defaultProxyMode;
    protected Class<? extends Annotation> scopeAnnotationType = Scope.class;

    public AnnotationScopeMetadataResolver() {
        this.defaultProxyMode = ScopedProxyMode.NO;
    }

    public AnnotationScopeMetadataResolver(ScopedProxyMode defaultProxyMode) {
        Assert.notNull((Object)((Object)defaultProxyMode), (String)"'defaultProxyMode' must not be null");
        this.defaultProxyMode = defaultProxyMode;
    }

    public void setScopeAnnotationType(Class<? extends Annotation> scopeAnnotationType) {
        Assert.notNull(scopeAnnotationType, (String)"'scopeAnnotationType' must not be null");
        this.scopeAnnotationType = scopeAnnotationType;
    }

    @Override
    public ScopeMetadata resolveScopeMetadata(BeanDefinition definition) {
        AnnotatedBeanDefinition annDef;
        MethodMetadata factoryMethodMetadata;
        MergedAnnotation annotation;
        ScopeMetadata metadata = new ScopeMetadata();
        if (definition instanceof AnnotatedBeanDefinition && (annotation = (factoryMethodMetadata = (annDef = (AnnotatedBeanDefinition)definition).getFactoryMethodMetadata()) != null ? factoryMethodMetadata.getAnnotation(this.scopeAnnotationType) : annDef.getMetadata().getAnnotation(this.scopeAnnotationType)).isPresent()) {
            Optional optional = annotation.getValue("proxyMode", ScopedProxyMode.class);
            if (optional.isPresent()) {
                ScopedProxyMode proxyMode = (ScopedProxyMode)((Object)optional.get());
                if (proxyMode == ScopedProxyMode.DEFAULT) {
                    proxyMode = this.defaultProxyMode;
                }
                metadata.setScopedProxyMode(proxyMode);
            }
            metadata.setScopeName(annotation.getStringValue());
        }
        return metadata;
    }
}

