/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.annotation;

import cn.taketoday.beans.factory.annotation.AnnotatedBeanDefinition;
import cn.taketoday.beans.factory.annotation.AutowiredAnnotationBeanPostProcessor;
import cn.taketoday.beans.factory.annotation.DisableDependencyInjection;
import cn.taketoday.beans.factory.annotation.EnableDependencyInjection;
import cn.taketoday.beans.factory.annotation.InitDestroyAnnotationBeanPostProcessor;
import cn.taketoday.beans.factory.config.BeanDefinition;
import cn.taketoday.beans.factory.config.BeanDefinitionHolder;
import cn.taketoday.beans.factory.support.AutowireCandidateResolver;
import cn.taketoday.beans.factory.support.BeanDefinitionRegistry;
import cn.taketoday.beans.factory.support.RootBeanDefinition;
import cn.taketoday.beans.factory.support.StandardBeanFactory;
import cn.taketoday.context.annotation.CommonAnnotationBeanPostProcessor;
import cn.taketoday.context.annotation.ConfigurationClassPostProcessor;
import cn.taketoday.context.annotation.ContextAnnotationAutowireCandidateResolver;
import cn.taketoday.context.annotation.DependsOn;
import cn.taketoday.context.annotation.Description;
import cn.taketoday.context.annotation.Lazy;
import cn.taketoday.context.annotation.Primary;
import cn.taketoday.context.annotation.Role;
import cn.taketoday.context.annotation.ScopeMetadata;
import cn.taketoday.context.annotation.ScopedProxyCreator;
import cn.taketoday.context.annotation.ScopedProxyMode;
import cn.taketoday.context.event.DefaultEventListenerFactory;
import cn.taketoday.context.event.EventListenerMethodProcessor;
import cn.taketoday.context.support.GenericApplicationContext;
import cn.taketoday.core.annotation.AnnotationAwareOrderComparator;
import cn.taketoday.core.annotation.MergedAnnotation;
import cn.taketoday.core.annotation.MergedAnnotations;
import cn.taketoday.core.type.AnnotationMetadata;
import cn.taketoday.core.type.MethodMetadata;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.ClassUtils;
import java.util.Comparator;
import java.util.function.Consumer;

public abstract class AnnotationConfigUtils {
    public static final String CONFIGURATION_ANNOTATION_PROCESSOR_BEAN_NAME = "cn.taketoday.context.annotation.internalConfigurationAnnotationProcessor";
    public static final String CONFIGURATION_BEAN_NAME_GENERATOR = "cn.taketoday.context.annotation.internalConfigurationBeanNameGenerator";
    private static final String JSR250_ANNOTATION_PROCESSOR_BEAN_NAME = "cn.taketoday.context.annotation.internalJsr250AnnotationProcessor";
    public static final String AUTOWIRED_ANNOTATION_PROCESSOR_BEAN_NAME = "cn.taketoday.context.annotation.internalAutowiredAnnotationProcessor";
    public static final String PERSISTENCE_ANNOTATION_PROCESSOR_BEAN_NAME = "cn.taketoday.context.annotation.internalPersistenceAnnotationProcessor";
    private static final String PERSISTENCE_ANNOTATION_PROCESSOR_CLASS_NAME = "cn.taketoday.orm.jpa.support.PersistenceAnnotationBeanPostProcessor";
    public static final String EVENT_LISTENER_PROCESSOR_BEAN_NAME = "cn.taketoday.context.event.internalEventListenerProcessor";
    public static final String EVENT_LISTENER_FACTORY_BEAN_NAME = "cn.taketoday.context.event.internalEventListenerFactory";
    public static final String COMMON_ANNOTATION_PROCESSOR_BEAN_NAME = "cn.taketoday.context.annotation.internalCommonAnnotationProcessor";
    private static final boolean jsr250Present = AnnotationConfigUtils.isPresent("javax.annotation.PostConstruct");
    private static final boolean jakartaAnnotationsPresent = AnnotationConfigUtils.isPresent("jakarta.annotation.PostConstruct");
    private static final boolean jpaPresent = AnnotationConfigUtils.isPresent("jakarta.persistence.EntityManagerFactory") && AnnotationConfigUtils.isPresent("cn.taketoday.orm.jpa.support.PersistenceAnnotationBeanPostProcessor");

    private static boolean isPresent(String className) {
        ClassLoader classLoader = AnnotationConfigUtils.class.getClassLoader();
        return ClassUtils.isPresent((String)className, (ClassLoader)classLoader);
    }

    public static void registerAnnotationConfigProcessors(BeanDefinitionRegistry registry) {
        AnnotationConfigUtils.registerAnnotationConfigProcessors(registry, null);
    }

    public static void registerAnnotationConfigProcessors(BeanDefinitionRegistry registry, @Nullable Consumer<BeanDefinitionHolder> consumer) {
        RootBeanDefinition def;
        StandardBeanFactory beanFactory = AnnotationConfigUtils.unwrapStandardBeanFactory(registry);
        if (beanFactory != null) {
            if (!(beanFactory.getDependencyComparator() instanceof AnnotationAwareOrderComparator)) {
                beanFactory.setDependencyComparator((Comparator)AnnotationAwareOrderComparator.INSTANCE);
            }
            if (!(beanFactory.getAutowireCandidateResolver() instanceof ContextAnnotationAutowireCandidateResolver)) {
                beanFactory.setAutowireCandidateResolver((AutowireCandidateResolver)new ContextAnnotationAutowireCandidateResolver());
            }
        }
        if (!registry.containsBeanDefinition(CONFIGURATION_ANNOTATION_PROCESSOR_BEAN_NAME)) {
            def = new RootBeanDefinition(ConfigurationClassPostProcessor.class);
            AnnotationConfigUtils.registerPostProcessor(registry, def, CONFIGURATION_ANNOTATION_PROCESSOR_BEAN_NAME, consumer);
        }
        if (!registry.containsBeanDefinition(AUTOWIRED_ANNOTATION_PROCESSOR_BEAN_NAME)) {
            def = new RootBeanDefinition(AutowiredAnnotationBeanPostProcessor.class);
            AnnotationConfigUtils.registerPostProcessor(registry, def, AUTOWIRED_ANNOTATION_PROCESSOR_BEAN_NAME, consumer);
        }
        if (jakartaAnnotationsPresent && !registry.containsBeanDefinition(COMMON_ANNOTATION_PROCESSOR_BEAN_NAME)) {
            def = new RootBeanDefinition(CommonAnnotationBeanPostProcessor.class);
            AnnotationConfigUtils.registerPostProcessor(registry, def, COMMON_ANNOTATION_PROCESSOR_BEAN_NAME, consumer);
        }
        if (jsr250Present && !registry.containsBeanDefinition(JSR250_ANNOTATION_PROCESSOR_BEAN_NAME)) {
            try {
                def = new RootBeanDefinition(InitDestroyAnnotationBeanPostProcessor.class);
                def.getPropertyValues().add("initAnnotationType", AnnotationConfigUtils.class.getClassLoader().loadClass("javax.annotation.PostConstruct"));
                def.getPropertyValues().add("destroyAnnotationType", AnnotationConfigUtils.class.getClassLoader().loadClass("javax.annotation.PreDestroy"));
                AnnotationConfigUtils.registerPostProcessor(registry, def, JSR250_ANNOTATION_PROCESSOR_BEAN_NAME, consumer);
            }
            catch (ClassNotFoundException def2) {
                // empty catch block
            }
        }
        if (jpaPresent && !registry.containsBeanDefinition(PERSISTENCE_ANNOTATION_PROCESSOR_BEAN_NAME)) {
            def = new RootBeanDefinition();
            try {
                def.setBeanClass(ClassUtils.forName((String)PERSISTENCE_ANNOTATION_PROCESSOR_CLASS_NAME, (ClassLoader)AnnotationConfigUtils.class.getClassLoader()));
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalStateException("Cannot load optional framework class: cn.taketoday.orm.jpa.support.PersistenceAnnotationBeanPostProcessor", ex);
            }
            AnnotationConfigUtils.registerPostProcessor(registry, def, PERSISTENCE_ANNOTATION_PROCESSOR_BEAN_NAME, consumer);
        }
        if (!registry.containsBeanDefinition(EVENT_LISTENER_PROCESSOR_BEAN_NAME)) {
            def = new RootBeanDefinition(EventListenerMethodProcessor.class);
            AnnotationConfigUtils.registerPostProcessor(registry, def, EVENT_LISTENER_PROCESSOR_BEAN_NAME, consumer);
        }
        if (!registry.containsBeanDefinition(EVENT_LISTENER_FACTORY_BEAN_NAME)) {
            def = new RootBeanDefinition(DefaultEventListenerFactory.class);
            AnnotationConfigUtils.registerPostProcessor(registry, def, EVENT_LISTENER_FACTORY_BEAN_NAME, consumer);
        }
    }

    private static void registerPostProcessor(BeanDefinitionRegistry registry, RootBeanDefinition definition, String beanName, @Nullable Consumer<BeanDefinitionHolder> consumer) {
        definition.setEnableDependencyInjection(false);
        definition.setRole(2);
        registry.registerBeanDefinition(beanName, (BeanDefinition)definition);
        if (consumer != null) {
            consumer.accept(new BeanDefinitionHolder((BeanDefinition)definition, beanName));
        }
    }

    @Nullable
    private static StandardBeanFactory unwrapStandardBeanFactory(BeanDefinitionRegistry registry) {
        if (registry instanceof StandardBeanFactory) {
            return (StandardBeanFactory)registry;
        }
        if (registry instanceof GenericApplicationContext) {
            return ((GenericApplicationContext)registry).getBeanFactory();
        }
        return null;
    }

    public static void processCommonDefinitionAnnotations(AnnotatedBeanDefinition abd) {
        AnnotationConfigUtils.applyAnnotationMetadata(abd);
    }

    static BeanDefinitionHolder applyScopedProxyMode(ScopeMetadata metadata, BeanDefinitionHolder definition, BeanDefinitionRegistry registry) {
        ScopedProxyMode scopedProxyMode = metadata.getScopedProxyMode();
        if (scopedProxyMode.equals((Object)ScopedProxyMode.NO)) {
            return definition;
        }
        boolean proxyTargetClass = scopedProxyMode.equals((Object)ScopedProxyMode.TARGET_CLASS);
        return ScopedProxyCreator.createScopedProxy(definition, registry, proxyTargetClass);
    }

    public static void applyAnnotationMetadata(AnnotatedBeanDefinition definition) {
        MethodMetadata metadata = definition.getFactoryMethodMetadata();
        if (metadata == null) {
            metadata = definition.getMetadata();
        }
        MergedAnnotations annotations = metadata.getAnnotations();
        AnnotationConfigUtils.applyAnnotationMetadata(annotations, (BeanDefinition)definition);
    }

    public static void applyAnnotationMetadata(MergedAnnotations annotations, BeanDefinition definition) {
        MergedAnnotation description;
        MergedAnnotation dependsOn;
        AnnotatedBeanDefinition annotated;
        AnnotationMetadata metadata;
        MergedAnnotation lazyMergedAnnotation;
        if (annotations.isPresent(Primary.class)) {
            definition.setPrimary(true);
        }
        if ((lazyMergedAnnotation = annotations.get(Lazy.class)).isPresent()) {
            definition.setLazyInit(lazyMergedAnnotation.getBooleanValue());
        } else if (definition instanceof AnnotatedBeanDefinition && (lazyMergedAnnotation = (metadata = (annotated = (AnnotatedBeanDefinition)definition).getMetadata()).getAnnotation(Lazy.class)).isPresent()) {
            definition.setLazyInit(lazyMergedAnnotation.getBooleanValue());
        }
        MergedAnnotation roleMergedAnnotation = annotations.get(Role.class);
        if (roleMergedAnnotation.isPresent()) {
            definition.setRole(roleMergedAnnotation.getIntValue());
        }
        if ((dependsOn = annotations.get(DependsOn.class)).isPresent()) {
            definition.setDependsOn(dependsOn.getStringValueArray());
        }
        if ((description = annotations.get(Description.class)).isPresent()) {
            definition.setDescription(description.getStringValue());
        }
        if (annotations.isPresent(EnableDependencyInjection.class)) {
            definition.setEnableDependencyInjection(true);
        } else if (annotations.isPresent(DisableDependencyInjection.class)) {
            definition.setEnableDependencyInjection(false);
        }
    }
}

