/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.annotation;

import cn.taketoday.beans.factory.annotation.AnnotatedBeanDefinition;
import cn.taketoday.beans.factory.config.BeanDefinition;
import cn.taketoday.beans.factory.config.BeanNameHolder;
import cn.taketoday.beans.factory.support.BeanDefinitionRegistry;
import cn.taketoday.beans.factory.support.BeanNameGenerator;
import cn.taketoday.core.annotation.MergedAnnotation;
import cn.taketoday.core.type.AnnotationMetadata;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Constant;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.ClassUtils;
import cn.taketoday.util.ObjectUtils;
import cn.taketoday.util.StringUtils;
import java.beans.Introspector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class AnnotationBeanNameGenerator
implements BeanNameGenerator {
    public static final AnnotationBeanNameGenerator INSTANCE = new AnnotationBeanNameGenerator();
    private static final String COMPONENT_ANNOTATION_CLASSNAME = "cn.taketoday.stereotype.Component";
    private final Map<String, Set<String>> metaAnnotationTypesCache = new ConcurrentHashMap<String, Set<String>>();

    public String generateBeanName(BeanDefinition definition, BeanDefinitionRegistry registry) {
        String beanName;
        if (definition instanceof AnnotatedBeanDefinition && StringUtils.hasText((String)(beanName = this.determineBeanNameFromAnnotation((AnnotatedBeanDefinition)definition)))) {
            return beanName;
        }
        return this.buildDefaultBeanName(definition, registry);
    }

    @Nullable
    protected String determineBeanNameFromAnnotation(AnnotatedBeanDefinition annotatedDef) {
        AnnotationMetadata amd = annotatedDef.getMetadata();
        Set types = amd.getAnnotationTypes();
        String beanName = null;
        for (String type : types) {
            String strVal;
            BeanNameHolder beanNameHolder;
            Set metaTypes;
            MergedAnnotation annotation = amd.getAnnotation(type);
            if (!annotation.isPresent() || !this.isStereotype(type, metaTypes = this.metaAnnotationTypesCache.computeIfAbsent(type, key -> {
                Set result = amd.getMetaAnnotationTypes(key);
                return result.isEmpty() ? Collections.emptySet() : result;
            })) || (beanNameHolder = this.getBeanNameHolder(annotation)) == null || !StringUtils.isNotEmpty((CharSequence)(strVal = beanNameHolder.getBeanName()))) continue;
            if (beanName != null && !strVal.equals(beanName)) {
                throw new IllegalStateException("Stereotype annotations suggest inconsistent component names: '" + beanName + "' versus '" + strVal + "'");
            }
            annotatedDef.setAttribute("beanNameHolder", (Object)beanNameHolder);
            beanName = strVal;
        }
        return beanName;
    }

    private BeanNameHolder getBeanNameHolder(MergedAnnotation<?> annotation) {
        Optional value = annotation.getValue("value");
        if (value.isPresent()) {
            Object[] nameArray;
            Object attribute = value.get();
            if (attribute instanceof String) {
                String beanName = (String)attribute;
                return new BeanNameHolder(beanName, null);
            }
            if (attribute instanceof String[] && ObjectUtils.isNotEmpty((Object[])(nameArray = (String[])attribute))) {
                Object beanName = nameArray[0];
                String[] aliasesArray = null;
                if (nameArray.length > 1) {
                    ArrayList<Object> aliases = new ArrayList<Object>();
                    for (int i = 1; i < nameArray.length; ++i) {
                        if (!StringUtils.hasText((String)nameArray[i])) continue;
                        aliases.add(nameArray[i]);
                    }
                    if (!aliases.isEmpty()) {
                        aliasesArray = aliases.toArray(Constant.EMPTY_STRING_ARRAY);
                    }
                }
                return new BeanNameHolder((String)beanName, aliasesArray);
            }
        }
        return null;
    }

    protected boolean isStereotype(String annotationType, Set<String> metaAnnotationTypes) {
        return annotationType.equals(COMPONENT_ANNOTATION_CLASSNAME) || metaAnnotationTypes.contains(COMPONENT_ANNOTATION_CLASSNAME) || annotationType.equals("jakarta.annotation.ManagedBean") || annotationType.equals("jakarta.inject.Named");
    }

    protected String buildDefaultBeanName(BeanDefinition definition, BeanDefinitionRegistry registry) {
        return this.buildDefaultBeanName(definition);
    }

    protected String buildDefaultBeanName(BeanDefinition definition) {
        String beanClassName = definition.getBeanClassName();
        Assert.state((beanClassName != null ? 1 : 0) != 0, (String)"No bean class name set");
        String shortClassName = ClassUtils.getShortName((String)beanClassName);
        return Introspector.decapitalize(shortClassName);
    }
}

