/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.annotation;

import cn.taketoday.context.annotation.AdviceMode;
import cn.taketoday.context.annotation.ImportSelector;
import cn.taketoday.core.GenericTypeResolver;
import cn.taketoday.core.annotation.MergedAnnotation;
import cn.taketoday.core.type.AnnotationMetadata;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import java.lang.annotation.Annotation;

public abstract class AdviceModeImportSelector<A extends Annotation>
implements ImportSelector {
    public static final String DEFAULT_ADVICE_MODE_ATTRIBUTE_NAME = "mode";

    protected String getAdviceModeAttributeName() {
        return DEFAULT_ADVICE_MODE_ATTRIBUTE_NAME;
    }

    @Override
    public final String[] selectImports(AnnotationMetadata importingClassMetadata) {
        Class annType = GenericTypeResolver.resolveTypeArgument(this.getClass(), AdviceModeImportSelector.class);
        Assert.state((annType != null ? 1 : 0) != 0, (String)"Unresolvable type argument for AdviceModeImportSelector");
        MergedAnnotation attributes = importingClassMetadata.getAnnotation(annType.getName());
        if (!attributes.isPresent()) {
            throw new IllegalArgumentException(String.format("@%s is not present on importing class '%s' as expected", annType.getSimpleName(), importingClassMetadata.getClassName()));
        }
        AdviceMode adviceMode = (AdviceMode)attributes.getEnum(this.getAdviceModeAttributeName(), AdviceMode.class);
        String[] imports = this.selectImports(adviceMode);
        if (imports == null) {
            throw new IllegalArgumentException("Unknown AdviceMode: " + adviceMode);
        }
        return imports;
    }

    @Nullable
    protected abstract String[] selectImports(AdviceMode var1);
}

