/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context;

import cn.taketoday.context.ApplicationEvent;
import cn.taketoday.core.ResolvableType;
import cn.taketoday.core.ResolvableTypeProvider;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;

public class PayloadApplicationEvent<T>
extends ApplicationEvent
implements ResolvableTypeProvider {
    private final T payload;
    private final ResolvableType payloadType;

    public PayloadApplicationEvent(Object source, T payload, @Nullable ResolvableType payloadType) {
        super(source);
        Assert.notNull(payload, (String)"Payload is required");
        this.payload = payload;
        this.payloadType = payloadType != null ? payloadType : ResolvableType.fromInstance(payload);
    }

    public PayloadApplicationEvent(Object source, T payload) {
        this(source, payload, null);
    }

    public ResolvableType getResolvableType() {
        return ResolvableType.fromClassWithGenerics(this.getClass(), (ResolvableType[])new ResolvableType[]{this.payloadType});
    }

    public T getPayload() {
        return this.payload;
    }
}

