/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context;

import cn.taketoday.beans.factory.BeanFactory;
import cn.taketoday.beans.factory.BeanFactoryUtils;
import cn.taketoday.beans.factory.NoSuchBeanDefinitionException;
import cn.taketoday.beans.factory.config.BeanDefinition;
import cn.taketoday.beans.factory.config.BeanDefinitionCustomizer;
import cn.taketoday.beans.factory.config.BeanDefinitionCustomizers;
import cn.taketoday.beans.factory.config.ExpressionEvaluator;
import cn.taketoday.beans.factory.config.SingletonBeanRegistry;
import cn.taketoday.beans.factory.parsing.FailFastProblemReporter;
import cn.taketoday.beans.factory.parsing.Problem;
import cn.taketoday.beans.factory.parsing.ProblemReporter;
import cn.taketoday.beans.factory.support.BeanDefinitionRegistry;
import cn.taketoday.beans.factory.support.BeanFactoryAwareInstantiator;
import cn.taketoday.beans.factory.support.BeanNameGenerator;
import cn.taketoday.beans.factory.support.SimpleBeanDefinitionRegistry;
import cn.taketoday.context.ApplicationContext;
import cn.taketoday.context.annotation.AnnotationBeanNameGenerator;
import cn.taketoday.context.annotation.AnnotationScopeMetadataResolver;
import cn.taketoday.context.annotation.ConditionEvaluator;
import cn.taketoday.context.annotation.ConfigurationCondition;
import cn.taketoday.context.annotation.ScopeMetadata;
import cn.taketoday.context.annotation.ScopeMetadataResolver;
import cn.taketoday.core.env.Environment;
import cn.taketoday.core.env.StandardEnvironment;
import cn.taketoday.core.io.DefaultPropertySourceFactory;
import cn.taketoday.core.io.PathMatchingPatternResourceLoader;
import cn.taketoday.core.io.PatternResourceLoader;
import cn.taketoday.core.io.PropertySourceFactory;
import cn.taketoday.core.io.Resource;
import cn.taketoday.core.io.ResourceLoader;
import cn.taketoday.core.type.AnnotatedTypeMetadata;
import cn.taketoday.core.type.AnnotationMetadata;
import cn.taketoday.core.type.classreading.CachingMetadataReaderFactory;
import cn.taketoday.core.type.classreading.MetadataReader;
import cn.taketoday.core.type.classreading.MetadataReaderFactory;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.CollectionUtils;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;

public class BootstrapContext
extends BeanDefinitionCustomizers {
    public static final String BEAN_NAME = "cn.taketoday.context.loader.internalBootstrapContext";
    private final BeanDefinitionRegistry registry;
    @Nullable
    private final ApplicationContext applicationContext;
    private ConditionEvaluator conditionEvaluator;
    private BeanFactoryAwareInstantiator instantiator;
    private MetadataReaderFactory metadataReaderFactory;
    @Nullable
    private PatternResourceLoader resourceLoader;
    private ScopeMetadataResolver scopeMetadataResolver;
    private PropertySourceFactory propertySourceFactory;
    private BeanNameGenerator beanNameGenerator = AnnotationBeanNameGenerator.INSTANCE;
    private ProblemReporter problemReporter = new FailFastProblemReporter();
    @Nullable
    private Environment environment;
    private BeanFactory beanFactory;

    public BootstrapContext(ApplicationContext context) {
        this((BeanDefinitionRegistry)new SimpleBeanDefinitionRegistry(), context);
    }

    public BootstrapContext(BeanDefinitionRegistry registry, @Nullable ApplicationContext context) {
        this(registry, null, context);
    }

    public BootstrapContext(BeanDefinitionRegistry registry, @Nullable ConditionEvaluator conditionEvaluator, @Nullable ApplicationContext context) {
        Assert.notNull((Object)registry, (String)"registry is required");
        this.registry = registry;
        this.resourceLoader = context;
        this.applicationContext = context;
        this.conditionEvaluator = conditionEvaluator;
        if (context == null) {
            if (registry instanceof BeanFactory) {
                BeanFactory beanFactory;
                this.beanFactory = beanFactory = (BeanFactory)registry;
            } else {
                throw new IllegalArgumentException("'registry' expect a BeanFactory when No ApplicationContext available");
            }
        }
    }

    public BeanDefinitionRegistry getRegistry() {
        return this.registry;
    }

    @Nullable
    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public Environment getEnvironment() {
        if (this.applicationContext == null) {
            if (this.environment == null) {
                this.environment = new StandardEnvironment();
            }
            return this.environment;
        }
        return this.applicationContext.getEnvironment();
    }

    public void setEnvironment(@Nullable Environment environment) {
        this.environment = environment;
    }

    public BeanFactory getBeanFactory() {
        if (this.applicationContext != null) {
            return this.applicationContext.getBeanFactory();
        }
        return this.beanFactory;
    }

    public <T> T unwrapFactory(Class<T> requiredType) {
        if (this.applicationContext != null) {
            return this.applicationContext.unwrapFactory(requiredType);
        }
        return (T)this.beanFactory.unwrap(requiredType);
    }

    public <T> T unwrapContext(Class<T> requiredType) {
        Assert.state((this.applicationContext != null ? 1 : 0) != 0, (String)"No ApplicationContext available");
        return (T)this.applicationContext.unwrap(requiredType);
    }

    public String generateBeanName(BeanDefinition definition) {
        return this.beanNameGenerator.generateBeanName(definition, this.registry);
    }

    public ConditionEvaluator getConditionEvaluator() {
        if (this.conditionEvaluator == null) {
            this.conditionEvaluator = this.applicationContext != null ? new ConditionEvaluator(this.applicationContext, this.registry) : new ConditionEvaluator(this.getEnvironment(), null, this.registry);
        }
        return this.conditionEvaluator;
    }

    public void registerBeanDefinition(String beanName, BeanDefinition definition) {
        if (definition.getScope() == null) {
            definition.setScope(this.resolveScopeName(definition));
        }
        if (CollectionUtils.isNotEmpty((Collection)this.customizers)) {
            for (BeanDefinitionCustomizer definitionCustomizer : this.customizers) {
                definitionCustomizer.customize(definition);
            }
        }
        this.registry.registerBeanDefinition(beanName, definition);
    }

    public void registerAlias(String beanName, String alias) {
        this.registry.registerAlias(beanName, alias);
    }

    public boolean containsBeanDefinition(Class<?> beanClass) {
        return this.registry.containsBeanDefinition(beanClass);
    }

    public boolean containsBeanDefinition(Class<?> type, boolean equals) {
        return this.registry.containsBeanDefinition(type, equals);
    }

    public boolean containsBeanDefinition(String beanName) {
        return this.registry.containsBeanDefinition(beanName);
    }

    public void removeBeanDefinition(String beanName) {
        this.registry.removeBeanDefinition(beanName);
    }

    public BeanDefinition getBeanDefinition(String beanName) {
        return this.registry.getBeanDefinition(beanName);
    }

    public boolean passCondition(AnnotatedTypeMetadata metadata, @Nullable ConfigurationCondition.ConfigurationPhase phase) {
        return this.getConditionEvaluator().passCondition(metadata, phase);
    }

    public boolean shouldSkip(@Nullable AnnotatedTypeMetadata metadata, @Nullable ConfigurationCondition.ConfigurationPhase phase) {
        return this.getConditionEvaluator().shouldSkip(metadata, phase);
    }

    public boolean passCondition(AnnotatedTypeMetadata metadata) {
        return this.getConditionEvaluator().passCondition(metadata);
    }

    public BeanFactoryAwareInstantiator getInstantiator() {
        if (this.instantiator == null) {
            this.instantiator = BeanFactoryAwareInstantiator.from((BeanFactory)this.applicationContext);
        }
        return this.instantiator;
    }

    public <T> T instantiate(Class<T> beanClass) {
        return (T)this.getInstantiator().instantiate(beanClass);
    }

    public <T> T instantiate(Class<T> beanClass, @Nullable Object[] providedArgs) {
        return (T)this.getInstantiator().instantiate(beanClass, providedArgs);
    }

    public void setResourceLoader(@Nullable ResourceLoader resourceLoader) {
        this.resourceLoader = PatternResourceLoader.fromResourceLoader((ResourceLoader)resourceLoader);
        this.metadataReaderFactory = new CachingMetadataReaderFactory(resourceLoader);
    }

    public PatternResourceLoader getResourceLoader() {
        if (this.resourceLoader == null) {
            this.resourceLoader = this.applicationContext != null ? this.applicationContext : new PathMatchingPatternResourceLoader();
            if (this.metadataReaderFactory == null) {
                this.metadataReaderFactory = new CachingMetadataReaderFactory((ResourceLoader)this.resourceLoader);
            }
        }
        return this.resourceLoader;
    }

    public void setMetadataReaderFactory(@Nullable MetadataReaderFactory metadataReaderFactory) {
        this.metadataReaderFactory = metadataReaderFactory;
    }

    public final MetadataReaderFactory getMetadataReaderFactory() {
        if (this.metadataReaderFactory == null) {
            if (this.resourceLoader == null) {
                this.getResourceLoader();
            } else {
                Object resourceLoader = this.resourceLoader instanceof PathMatchingPatternResourceLoader ? ((PathMatchingPatternResourceLoader)this.resourceLoader).getRootLoader() : this.resourceLoader;
                this.metadataReaderFactory = new CachingMetadataReaderFactory((ResourceLoader)resourceLoader);
            }
        }
        return this.metadataReaderFactory;
    }

    public AnnotationMetadata getAnnotationMetadata(String className) throws IOException {
        return this.getMetadataReader(className).getAnnotationMetadata();
    }

    public MetadataReader getMetadataReader(String className) throws IOException {
        MetadataReaderFactory metadataFactory = this.getMetadataReaderFactory();
        return metadataFactory.getMetadataReader(className);
    }

    public void clearCache() {
        MetadataReaderFactory metadataReaderFactory = this.metadataReaderFactory;
        if (metadataReaderFactory instanceof CachingMetadataReaderFactory) {
            CachingMetadataReaderFactory cmef = (CachingMetadataReaderFactory)metadataReaderFactory;
            cmef.clearCache();
        }
    }

    public String evaluateExpression(String expression) {
        return this.evaluateExpression(expression, String.class);
    }

    public <T> T evaluateExpression(String expression, Class<T> requiredType) {
        ExpressionEvaluator expressionEvaluator = this.applicationContext != null ? this.applicationContext.getExpressionEvaluator() : ExpressionEvaluator.from((BeanFactory)this.getBeanFactory());
        return (T)expressionEvaluator.evaluate(expression, requiredType);
    }

    public Resource getResource(String location) {
        return this.getResourceLoader().getResource(location);
    }

    public Set<Resource> getResources(String locationPattern) throws IOException {
        return this.getResourceLoader().getResources(locationPattern);
    }

    public void setScopeMetadataResolver(ScopeMetadataResolver scopeMetadataResolver) {
        Assert.notNull((Object)scopeMetadataResolver, (String)"ScopeMetadataResolver is required");
        this.scopeMetadataResolver = scopeMetadataResolver;
    }

    public ScopeMetadataResolver getScopeMetadataResolver() {
        if (this.scopeMetadataResolver == null) {
            this.scopeMetadataResolver = new AnnotationScopeMetadataResolver();
        }
        return this.scopeMetadataResolver;
    }

    public String resolveScopeName(BeanDefinition definition) {
        return this.resolveScopeMetadata(definition).getScopeName();
    }

    public ScopeMetadata resolveScopeMetadata(BeanDefinition definition) {
        return this.getScopeMetadataResolver().resolveScopeMetadata(definition);
    }

    public void setPropertySourceFactory(@Nullable PropertySourceFactory propertySourceFactory) {
        this.propertySourceFactory = propertySourceFactory;
    }

    public PropertySourceFactory getPropertySourceFactory() {
        if (this.propertySourceFactory == null) {
            this.propertySourceFactory = new DefaultPropertySourceFactory();
        }
        return this.propertySourceFactory;
    }

    public void setBeanNameGenerator(@Nullable BeanNameGenerator beanNameGenerator) {
        this.beanNameGenerator = beanNameGenerator != null ? beanNameGenerator : AnnotationBeanNameGenerator.INSTANCE;
    }

    public BeanNameGenerator getBeanNameGenerator() {
        return this.beanNameGenerator;
    }

    public void setProblemReporter(ProblemReporter problemReporter) {
        Assert.notNull((Object)problemReporter, (String)"problemReporter is required");
        this.problemReporter = problemReporter;
    }

    public ProblemReporter getProblemReporter() {
        return this.problemReporter;
    }

    public void reportError(Problem problem) {
        this.problemReporter.error(problem);
    }

    public void reportWarning(Problem problem) {
        this.problemReporter.warning(problem);
    }

    public void reportFatal(Problem problem) {
        this.problemReporter.fatal(problem);
    }

    public ClassLoader getClassLoader() {
        return this.getResourceLoader().getClassLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BootstrapContext from(BeanFactory beanFactory) {
        Assert.notNull((Object)beanFactory, (String)"beanFactory is required");
        BootstrapContext context = BootstrapContext.findContext(beanFactory);
        if (context == null) {
            BeanFactory beanFactory2 = beanFactory;
            synchronized (beanFactory2) {
                context = BootstrapContext.findContext(beanFactory);
                if (context == null) {
                    context = new BootstrapContext(BootstrapContext.deduceRegistry(beanFactory), BootstrapContext.deduceContext(beanFactory));
                    ((SingletonBeanRegistry)beanFactory.unwrap(SingletonBeanRegistry.class)).registerSingleton(BEAN_NAME, (Object)context);
                }
            }
        }
        return context;
    }

    static BeanDefinitionRegistry deduceRegistry(BeanFactory beanFactory) {
        if (beanFactory instanceof BeanDefinitionRegistry) {
            BeanDefinitionRegistry registry = (BeanDefinitionRegistry)beanFactory;
            return registry;
        }
        throw new IllegalArgumentException("Expect a BeanDefinitionRegistry");
    }

    static ApplicationContext deduceContext(BeanFactory beanFactory) {
        if (beanFactory instanceof ApplicationContext) {
            ApplicationContext context = (ApplicationContext)beanFactory;
            return context;
        }
        try {
            return (ApplicationContext)beanFactory.getBean(ApplicationContext.class);
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            return null;
        }
    }

    @Nullable
    private static BootstrapContext findContext(BeanFactory beanFactory) {
        return (BootstrapContext)((Object)BeanFactoryUtils.findLocal((BeanFactory)beanFactory, (String)BEAN_NAME, BootstrapContext.class));
    }
}

