/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.cache.support;

import cn.taketoday.lang.NullValue;
import java.io.Serializable;
import java.util.Arrays;

public class DefaultCacheKey
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final DefaultCacheKey EMPTY = new DefaultCacheKey(new Object[]{NullValue.INSTANCE});
    private final int hash;
    private final Object[] params;

    public DefaultCacheKey(Object[] params) {
        if (params == null) {
            this.params = EMPTY.getParams();
        } else {
            this.params = new Object[params.length];
            System.arraycopy(params, 0, this.params, 0, params.length);
        }
        this.hash = Arrays.hashCode(this.params);
    }

    public boolean equals(Object other) {
        return this == other || other instanceof DefaultCacheKey && Arrays.deepEquals(this.getParams(), ((DefaultCacheKey)other).getParams());
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " " + Arrays.toString(this.getParams());
    }

    public Object[] getParams() {
        return this.params;
    }
}

