/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.cache.interceptor;

import cn.taketoday.cache.interceptor.CacheOperation;
import cn.taketoday.cache.interceptor.CacheOperationSource;
import cn.taketoday.lang.Nullable;
import cn.taketoday.logging.Logger;
import cn.taketoday.logging.LoggerFactory;
import cn.taketoday.util.ObjectUtils;
import cn.taketoday.util.StringUtils;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class NameMatchCacheOperationSource
implements CacheOperationSource,
Serializable {
    protected static final Logger logger = LoggerFactory.getLogger(NameMatchCacheOperationSource.class);
    private final Map<String, Collection<CacheOperation>> nameMap = new LinkedHashMap<String, Collection<CacheOperation>>();

    public void setNameMap(Map<String, Collection<CacheOperation>> nameMap) {
        nameMap.forEach(this::addCacheMethod);
    }

    public void addCacheMethod(String methodName, Collection<CacheOperation> ops) {
        if (logger.isDebugEnabled()) {
            logger.debug("Adding method [{}] with cache operations [{}]", (Object)methodName, ops);
        }
        this.nameMap.put(methodName, ops);
    }

    @Override
    @Nullable
    public Collection<CacheOperation> getCacheOperations(Method method, @Nullable Class<?> targetClass) {
        String methodName = method.getName();
        Collection<CacheOperation> ops = this.nameMap.get(methodName);
        if (ops == null) {
            String bestNameMatch = null;
            for (String mappedName : this.nameMap.keySet()) {
                if (!this.isMatch(methodName, mappedName) || bestNameMatch != null && bestNameMatch.length() > mappedName.length()) continue;
                ops = this.nameMap.get(mappedName);
                bestNameMatch = mappedName;
            }
        }
        return ops;
    }

    protected boolean isMatch(String methodName, String mappedName) {
        return StringUtils.simpleMatch((String)mappedName, (String)methodName);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof NameMatchCacheOperationSource)) {
            return false;
        }
        NameMatchCacheOperationSource otherTas = (NameMatchCacheOperationSource)other;
        return ObjectUtils.nullSafeEquals(this.nameMap, otherTas.nameMap);
    }

    public int hashCode() {
        return NameMatchCacheOperationSource.class.hashCode();
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.nameMap;
    }
}

