/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.cache.interceptor;

import cn.taketoday.cache.Cache;
import cn.taketoday.cache.interceptor.CacheErrorHandler;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.logging.Logger;
import cn.taketoday.logging.LoggerFactory;

public class LoggingCacheErrorHandler
implements CacheErrorHandler {
    private final Logger logger;
    private final boolean logStackTraces;

    public LoggingCacheErrorHandler() {
        this(false);
    }

    public LoggingCacheErrorHandler(Logger logger, boolean logStackTraces) {
        Assert.notNull((Object)logger, (String)"Logger must not be null");
        this.logger = logger;
        this.logStackTraces = logStackTraces;
    }

    public LoggingCacheErrorHandler(boolean logStackTraces) {
        this(LoggerFactory.getLogger(LoggingCacheErrorHandler.class), logStackTraces);
    }

    public LoggingCacheErrorHandler(String loggerName, boolean logStackTraces) {
        Assert.notNull((Object)loggerName, (String)"'loggerName' is required");
        this.logger = LoggerFactory.getLogger((String)loggerName);
        this.logStackTraces = logStackTraces;
    }

    @Override
    public void handleCacheGetError(RuntimeException exception, Cache cache, Object key) {
        if (this.logger.isWarnEnabled()) {
            this.doLogCacheError(this.logger, this.createMessage(cache, "failed to get entry with key '" + key + "'"), exception);
        }
    }

    @Override
    public void handleCachePutError(RuntimeException exception, Cache cache, Object key, @Nullable Object value) {
        if (this.logger.isWarnEnabled()) {
            this.doLogCacheError(this.logger, this.createMessage(cache, "failed to put entry with key '" + key + "'"), exception);
        }
    }

    @Override
    public void handleCacheEvictError(RuntimeException exception, Cache cache, Object key) {
        if (this.logger.isWarnEnabled()) {
            this.doLogCacheError(this.logger, this.createMessage(cache, "failed to evict entry with key '" + key + "'"), exception);
        }
    }

    @Override
    public void handleCacheClearError(RuntimeException exception, Cache cache) {
        if (this.logger.isWarnEnabled()) {
            this.doLogCacheError(this.logger, this.createMessage(cache, "failed to clear entries"), exception);
        }
    }

    protected final Logger getLogger() {
        return this.logger;
    }

    protected final boolean isLogStackTraces() {
        return this.logStackTraces;
    }

    protected void doLogCacheError(Logger logger, String message, RuntimeException ex) {
        if (this.logStackTraces) {
            logger.warn(message, (Throwable)ex);
        } else {
            logger.warn(message);
        }
    }

    private String createMessage(Cache cache, String reason) {
        return String.format("Cache '%s' %s", cache.getName(), reason);
    }
}

