/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.cache.interceptor;

import cn.taketoday.aop.Pointcut;
import cn.taketoday.aop.framework.AbstractSingletonProxyFactoryBean;
import cn.taketoday.aop.support.DefaultPointcutAdvisor;
import cn.taketoday.beans.factory.BeanFactory;
import cn.taketoday.beans.factory.BeanFactoryAware;
import cn.taketoday.beans.factory.SmartInitializingSingleton;
import cn.taketoday.beans.factory.config.ConfigurableBeanFactory;
import cn.taketoday.cache.CacheManager;
import cn.taketoday.cache.interceptor.CacheInterceptor;
import cn.taketoday.cache.interceptor.CacheOperationSource;
import cn.taketoday.cache.interceptor.CacheResolver;
import cn.taketoday.cache.interceptor.KeyGenerator;
import org.aopalliance.aop.Advice;

public class CacheProxyFactoryBean
extends AbstractSingletonProxyFactoryBean
implements BeanFactoryAware,
SmartInitializingSingleton {
    private final CacheInterceptor cacheInterceptor = new CacheInterceptor();
    private Pointcut pointcut = Pointcut.TRUE;

    public void setCacheOperationSources(CacheOperationSource ... cacheOperationSources) {
        this.cacheInterceptor.setCacheOperationSources(cacheOperationSources);
    }

    public void setKeyGenerator(KeyGenerator keyGenerator) {
        this.cacheInterceptor.setKeyGenerator(keyGenerator);
    }

    public void setCacheResolver(CacheResolver cacheResolver) {
        this.cacheInterceptor.setCacheResolver(cacheResolver);
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheInterceptor.setCacheManager(cacheManager);
    }

    public void setPointcut(Pointcut pointcut) {
        this.pointcut = pointcut;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.cacheInterceptor.setBeanFactory(beanFactory);
    }

    public void afterSingletonsInstantiated() {
        this.cacheInterceptor.afterSingletonsInstantiated();
    }

    public void afterSingletonsInstantiated(ConfigurableBeanFactory beanFactory) {
        this.cacheInterceptor.afterSingletonsInstantiated(beanFactory);
    }

    protected Object createMainInterceptor() {
        this.cacheInterceptor.afterPropertiesSet();
        return new DefaultPointcutAdvisor(this.pointcut, (Advice)this.cacheInterceptor);
    }
}

