/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.cache.interceptor;

import cn.taketoday.cache.interceptor.CacheAspectSupport;
import cn.taketoday.cache.interceptor.CacheOperationInvoker;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import java.io.Serializable;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class CacheInterceptor
extends CacheAspectSupport
implements MethodInterceptor,
Serializable {
    @Nullable
    public Object invoke(MethodInvocation invocation) throws Throwable {
        Method method = invocation.getMethod();
        CacheOperationInvoker aopAllianceInvoker = () -> {
            try {
                return invocation.proceed();
            }
            catch (Throwable ex) {
                throw new CacheOperationInvoker.ThrowableWrapper(ex);
            }
        };
        Object target = invocation.getThis();
        Assert.state((target != null ? 1 : 0) != 0, (String)"Target must not be null");
        try {
            return this.execute(aopAllianceInvoker, target, method, invocation.getArguments());
        }
        catch (CacheOperationInvoker.ThrowableWrapper th) {
            throw th.getOriginal();
        }
    }
}

