/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.cache.interceptor;

import cn.taketoday.aop.support.AopUtils;
import cn.taketoday.cache.interceptor.CacheOperation;
import cn.taketoday.cache.interceptor.CacheOperationSource;
import cn.taketoday.lang.Nullable;
import cn.taketoday.logging.Logger;
import cn.taketoday.logging.LoggerFactory;
import cn.taketoday.util.ClassUtils;
import cn.taketoday.util.MethodClassKey;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractFallbackCacheOperationSource
implements CacheOperationSource {
    private static final Collection<CacheOperation> NULL_CACHING_ATTRIBUTE = Collections.emptyList();
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<Object, Collection<CacheOperation>> attributeCache = new ConcurrentHashMap<Object, Collection<CacheOperation>>(1024);

    @Override
    @Nullable
    public Collection<CacheOperation> getCacheOperations(Method method, @Nullable Class<?> targetClass) {
        if (method.getDeclaringClass() == Object.class) {
            return null;
        }
        Object cacheKey = this.getCacheKey(method, targetClass);
        Collection<CacheOperation> cached = this.attributeCache.get(cacheKey);
        if (cached != null) {
            return cached != NULL_CACHING_ATTRIBUTE ? cached : null;
        }
        Collection<CacheOperation> cacheOps = this.computeCacheOperations(method, targetClass);
        if (cacheOps != null) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Adding cacheable method '{}' with attribute: {}", (Object)method.getName(), cacheOps);
            }
            this.attributeCache.put(cacheKey, cacheOps);
        } else {
            this.attributeCache.put(cacheKey, NULL_CACHING_ATTRIBUTE);
        }
        return cacheOps;
    }

    protected Object getCacheKey(Method method, @Nullable Class<?> targetClass) {
        return new MethodClassKey(method, targetClass);
    }

    @Nullable
    private Collection<CacheOperation> computeCacheOperations(Method method, @Nullable Class<?> targetClass) {
        if (this.allowPublicMethodsOnly() && !Modifier.isPublic(method.getModifiers())) {
            return null;
        }
        Method specificMethod = AopUtils.getMostSpecificMethod((Method)method, targetClass);
        Collection<CacheOperation> opDef = this.findCacheOperations(specificMethod);
        if (opDef != null) {
            return opDef;
        }
        opDef = this.findCacheOperations(specificMethod.getDeclaringClass());
        if (opDef != null && ClassUtils.isUserLevelMethod((Method)method)) {
            return opDef;
        }
        if (specificMethod != method) {
            opDef = this.findCacheOperations(method);
            if (opDef != null) {
                return opDef;
            }
            opDef = this.findCacheOperations(method.getDeclaringClass());
            if (opDef != null && ClassUtils.isUserLevelMethod((Method)method)) {
                return opDef;
            }
        }
        return null;
    }

    @Nullable
    protected abstract Collection<CacheOperation> findCacheOperations(Class<?> var1);

    @Nullable
    protected abstract Collection<CacheOperation> findCacheOperations(Method var1);

    protected boolean allowPublicMethodsOnly() {
        return false;
    }
}

