/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.cache.interceptor;

import cn.taketoday.beans.factory.InitializingBean;
import cn.taketoday.cache.Cache;
import cn.taketoday.cache.CacheManager;
import cn.taketoday.cache.interceptor.CacheOperationInvocationContext;
import cn.taketoday.cache.interceptor.CacheResolver;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public abstract class AbstractCacheResolver
implements CacheResolver,
InitializingBean {
    @Nullable
    private CacheManager cacheManager;

    protected AbstractCacheResolver() {
    }

    protected AbstractCacheResolver(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public CacheManager getCacheManager() {
        Assert.state((this.cacheManager != null ? 1 : 0) != 0, (String)"No CacheManager set");
        return this.cacheManager;
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.cacheManager, (String)"CacheManager is required");
    }

    @Override
    public Collection<? extends Cache> resolveCaches(CacheOperationInvocationContext<?> context) {
        Collection<String> cacheNames = this.getCacheNames(context);
        if (cacheNames == null) {
            return Collections.emptyList();
        }
        ArrayList<Cache> result = new ArrayList<Cache>(cacheNames.size());
        CacheManager cacheManager = this.getCacheManager();
        for (String cacheName : cacheNames) {
            Cache cache = cacheManager.getCache(cacheName);
            if (cache == null) {
                throw new IllegalArgumentException("Cannot find cache named '" + cacheName + "' for " + context.getOperation());
            }
            result.add(cache);
        }
        return result;
    }

    @Nullable
    protected abstract Collection<String> getCacheNames(CacheOperationInvocationContext<?> var1);
}

