/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.cache.interceptor;

import cn.taketoday.cache.Cache;
import cn.taketoday.cache.interceptor.CacheErrorHandler;
import cn.taketoday.cache.interceptor.SimpleCacheErrorHandler;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.function.SingletonSupplier;

public abstract class AbstractCacheInvoker {
    protected SingletonSupplier<CacheErrorHandler> errorHandler;

    protected AbstractCacheInvoker() {
        this.errorHandler = SingletonSupplier.from(SimpleCacheErrorHandler::new);
    }

    protected AbstractCacheInvoker(CacheErrorHandler errorHandler) {
        this.errorHandler = SingletonSupplier.valueOf((Object)errorHandler);
    }

    public void setErrorHandler(CacheErrorHandler errorHandler) {
        this.errorHandler = SingletonSupplier.valueOf((Object)errorHandler);
    }

    public CacheErrorHandler getErrorHandler() {
        return (CacheErrorHandler)this.errorHandler.obtain();
    }

    @Nullable
    protected Cache.ValueWrapper doGet(Cache cache, Object key) {
        try {
            return cache.get(key);
        }
        catch (RuntimeException ex) {
            this.getErrorHandler().handleCacheGetError(ex, cache, key);
            return null;
        }
    }

    protected void doPut(Cache cache, Object key, @Nullable Object result) {
        try {
            cache.put(key, result);
        }
        catch (RuntimeException ex) {
            this.getErrorHandler().handleCachePutError(ex, cache, key, result);
        }
    }

    protected void doEvict(Cache cache, Object key, boolean immediate) {
        try {
            if (immediate) {
                cache.evictIfPresent(key);
            } else {
                cache.evict(key);
            }
        }
        catch (RuntimeException ex) {
            this.getErrorHandler().handleCacheEvictError(ex, cache, key);
        }
    }

    protected void doClear(Cache cache, boolean immediate) {
        try {
            if (immediate) {
                cache.invalidate();
            } else {
                cache.clear();
            }
        }
        catch (RuntimeException ex) {
            this.getErrorHandler().handleCacheClearError(ex, cache);
        }
    }
}

