/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.cache.config;

import cn.taketoday.beans.factory.config.BeanDefinition;
import cn.taketoday.beans.factory.config.RuntimeBeanReference;
import cn.taketoday.beans.factory.xml.BeanDefinitionParser;
import cn.taketoday.beans.factory.xml.NamespaceHandlerSupport;
import cn.taketoday.cache.config.AnnotationDrivenCacheBeanDefinitionParser;
import cn.taketoday.cache.config.CacheAdviceParser;
import cn.taketoday.util.StringUtils;
import org.w3c.dom.Element;

public class CacheNamespaceHandler
extends NamespaceHandlerSupport {
    static final String CACHE_MANAGER_ATTRIBUTE = "cache-manager";
    static final String DEFAULT_CACHE_MANAGER_BEAN_NAME = "cacheManager";

    static String extractCacheManager(Element element) {
        return element.hasAttribute(CACHE_MANAGER_ATTRIBUTE) ? element.getAttribute(CACHE_MANAGER_ATTRIBUTE) : DEFAULT_CACHE_MANAGER_BEAN_NAME;
    }

    static BeanDefinition parseKeyGenerator(Element element, BeanDefinition def) {
        String name = element.getAttribute("key-generator");
        if (StringUtils.hasText((String)name)) {
            def.getPropertyValues().add("keyGenerator", (Object)new RuntimeBeanReference(name.trim()));
        }
        return def;
    }

    public void init() {
        this.registerBeanDefinitionParser("annotation-driven", new AnnotationDrivenCacheBeanDefinitionParser());
        this.registerBeanDefinitionParser("advice", (BeanDefinitionParser)new CacheAdviceParser());
    }
}

