/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.cache.annotation;

import cn.taketoday.beans.factory.annotation.DisableAllDependencyInjection;
import cn.taketoday.cache.annotation.AbstractCachingConfiguration;
import cn.taketoday.cache.annotation.AnnotationCacheOperationSource;
import cn.taketoday.cache.interceptor.BeanFactoryCacheOperationSourceAdvisor;
import cn.taketoday.cache.interceptor.CacheInterceptor;
import cn.taketoday.cache.interceptor.CacheOperationSource;
import cn.taketoday.context.annotation.Bean;
import cn.taketoday.context.annotation.Configuration;
import cn.taketoday.context.annotation.Role;
import org.aopalliance.aop.Advice;

@DisableAllDependencyInjection
@Configuration(proxyBeanMethods=false)
@Role(value=2)
public class ProxyCachingConfiguration
extends AbstractCachingConfiguration {
    @Bean(name={"cn.taketoday.cache.config.internalCacheAdvisor"})
    @Role(value=2)
    public BeanFactoryCacheOperationSourceAdvisor cacheAdvisor(CacheOperationSource cacheOperationSource, CacheInterceptor cacheInterceptor) {
        BeanFactoryCacheOperationSourceAdvisor advisor = new BeanFactoryCacheOperationSourceAdvisor();
        advisor.setCacheOperationSource(cacheOperationSource);
        advisor.setAdvice((Advice)cacheInterceptor);
        if (this.enableCaching != null) {
            advisor.setOrder((Integer)this.enableCaching.getNumber("order"));
        }
        return advisor;
    }

    @Bean
    @Role(value=2)
    public CacheOperationSource cacheOperationSource() {
        return new AnnotationCacheOperationSource(false);
    }

    @Bean
    @Role(value=2)
    public CacheInterceptor cacheInterceptor(CacheOperationSource cacheOperationSource) {
        CacheInterceptor interceptor = new CacheInterceptor();
        interceptor.configure(this.errorHandler, this.keyGenerator, this.cacheResolver, this.cacheManager);
        interceptor.setCacheOperationSource(cacheOperationSource);
        return interceptor;
    }
}

