/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.cache.annotation;

import cn.taketoday.cache.annotation.EnableCaching;
import cn.taketoday.cache.annotation.ProxyCachingConfiguration;
import cn.taketoday.context.annotation.AdviceMode;
import cn.taketoday.context.annotation.AdviceModeImportSelector;
import cn.taketoday.context.annotation.AutoProxyRegistrar;
import cn.taketoday.util.ClassUtils;
import cn.taketoday.util.StringUtils;
import java.util.ArrayList;

public class CachingConfigurationSelector
extends AdviceModeImportSelector<EnableCaching> {
    private static final String PROXY_JCACHE_CONFIGURATION_CLASS = "cn.taketoday.cache.jcache.config.ProxyJCacheConfiguration";
    private static final String CACHE_ASPECT_CONFIGURATION_CLASS_NAME = "cn.taketoday.cache.aspectj.AspectJCachingConfiguration";
    private static final String JCACHE_ASPECT_CONFIGURATION_CLASS_NAME = "cn.taketoday.cache.aspectj.AspectJJCacheConfiguration";
    private static final boolean jsr107Present;
    private static final boolean jcacheImplPresent;

    @Override
    public String[] selectImports(AdviceMode adviceMode) {
        return switch (adviceMode) {
            default -> throw new IncompatibleClassChangeError();
            case AdviceMode.PROXY -> this.getProxyImports();
            case AdviceMode.ASPECTJ -> this.getAspectJImports();
        };
    }

    private String[] getProxyImports() {
        ArrayList<String> result = new ArrayList<String>(3);
        result.add(AutoProxyRegistrar.class.getName());
        result.add(ProxyCachingConfiguration.class.getName());
        if (jsr107Present && jcacheImplPresent) {
            result.add(PROXY_JCACHE_CONFIGURATION_CLASS);
        }
        return StringUtils.toStringArray(result);
    }

    private String[] getAspectJImports() {
        ArrayList<String> result = new ArrayList<String>(2);
        result.add(CACHE_ASPECT_CONFIGURATION_CLASS_NAME);
        if (jsr107Present && jcacheImplPresent) {
            result.add(JCACHE_ASPECT_CONFIGURATION_CLASS_NAME);
        }
        return StringUtils.toStringArray(result);
    }

    static {
        ClassLoader classLoader = CachingConfigurationSelector.class.getClassLoader();
        jsr107Present = ClassUtils.isPresent((String)"javax.cache.Cache", (ClassLoader)classLoader);
        jcacheImplPresent = ClassUtils.isPresent((String)PROXY_JCACHE_CONFIGURATION_CLASS, (ClassLoader)classLoader);
    }
}

