/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.cache.annotation;

import cn.taketoday.beans.BeansException;
import cn.taketoday.beans.factory.BeanFactory;
import cn.taketoday.beans.factory.BeanFactoryAware;
import cn.taketoday.beans.factory.annotation.DisableDependencyInjection;
import cn.taketoday.cache.CacheManager;
import cn.taketoday.cache.annotation.CachingConfigurer;
import cn.taketoday.cache.annotation.EnableCaching;
import cn.taketoday.cache.interceptor.CacheErrorHandler;
import cn.taketoday.cache.interceptor.CacheResolver;
import cn.taketoday.cache.interceptor.KeyGenerator;
import cn.taketoday.context.annotation.Configuration;
import cn.taketoday.context.annotation.ImportAware;
import cn.taketoday.core.annotation.AnnotationAttributes;
import cn.taketoday.core.type.AnnotationMetadata;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.CollectionUtils;
import cn.taketoday.util.function.SingletonSupplier;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;

@DisableDependencyInjection
@Configuration(proxyBeanMethods=false)
public abstract class AbstractCachingConfiguration
implements ImportAware,
BeanFactoryAware {
    @Nullable
    protected AnnotationAttributes enableCaching;
    @Nullable
    protected Supplier<CacheManager> cacheManager;
    @Nullable
    protected Supplier<CacheResolver> cacheResolver;
    @Nullable
    protected Supplier<KeyGenerator> keyGenerator;
    @Nullable
    protected Supplier<CacheErrorHandler> errorHandler;

    @Override
    public void setImportMetadata(AnnotationMetadata importMetadata) {
        this.enableCaching = AnnotationAttributes.fromMap((Map)importMetadata.getAnnotationAttributes(EnableCaching.class.getName()));
        if (this.enableCaching == null) {
            throw new IllegalArgumentException("@EnableCaching is not present on importing class " + importMetadata.getClassName());
        }
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.useCachingConfigurer(new CachingConfigurerSupplier(() -> {
            Set candidates = beanFactory.getBeanNamesForType(CachingConfigurer.class);
            if (CollectionUtils.isEmpty((Collection)candidates)) {
                return null;
            }
            if (candidates.size() > 1) {
                throw new IllegalStateException(candidates.size() + " implementations of CachingConfigurer were found when only 1 was expected. Refactor the configuration such that CachingConfigurer is implemented only once or not at all.");
            }
            return (CachingConfigurer)beanFactory.getBean((String)CollectionUtils.firstElement((Iterable)candidates), CachingConfigurer.class);
        }));
    }

    protected void useCachingConfigurer(CachingConfigurerSupplier cachingConfigurerSupplier) {
        this.cacheManager = cachingConfigurerSupplier.adapt(CachingConfigurer::cacheManager);
        this.cacheResolver = cachingConfigurerSupplier.adapt(CachingConfigurer::cacheResolver);
        this.keyGenerator = cachingConfigurerSupplier.adapt(CachingConfigurer::keyGenerator);
        this.errorHandler = cachingConfigurerSupplier.adapt(CachingConfigurer::errorHandler);
    }

    protected static class CachingConfigurerSupplier {
        private final Supplier<CachingConfigurer> supplier;

        public CachingConfigurerSupplier(Supplier<CachingConfigurer> supplier) {
            this.supplier = SingletonSupplier.from(supplier);
        }

        @Nullable
        public <T> Supplier<T> adapt(Function<CachingConfigurer, T> provider) {
            return () -> {
                CachingConfigurer cachingConfigurer = this.supplier.get();
                return cachingConfigurer != null ? provider.apply(cachingConfigurer) : null;
            };
        }
    }
}

