/*
 * Original Author -> Harry Yang (taketoday@foxmail.com) https://taketoday.cn
 * Copyright © TODAY & 2017 - 2021 All Rights Reserved.
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see [http://www.gnu.org/licenses/]
 */

package cn.taketoday.context.condition;

/**
 * Some named search strategies for beans in the bean factory hierarchy.
 *
 * @author <a href="https://github.com/TAKETODAY">Harry Yang 2021/11/25 21:35</a>
 * @author Dave Syer
 * @since 4.0
 */
public enum SearchStrategy {

  /**
   * Search only the current context.
   */
  CURRENT,

  /**
   * Search all ancestors, but not the current context.
   */
  ANCESTORS,

  /**
   * Search the entire hierarchy.
   */
  ALL

}
