/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.expression.parser;

import cn.taketoday.context.utils.StringUtils;
import cn.taketoday.expression.ExpressionException;
import cn.taketoday.expression.FunctionMapper;
import cn.taketoday.expression.LambdaExpression;
import cn.taketoday.expression.ValueExpression;
import cn.taketoday.expression.VariableMapper;
import cn.taketoday.expression.lang.EvaluationContext;
import cn.taketoday.expression.parser.AstMethodArguments;
import cn.taketoday.expression.parser.ELParserTreeConstants;
import cn.taketoday.expression.parser.Node;
import cn.taketoday.expression.parser.SimpleNode;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class AstFunction
extends SimpleNode {
    protected String prefix = "";
    protected String localName = "";

    public AstFunction(int id) {
        super(id);
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getOutputName() {
        if (StringUtils.isEmpty(this.prefix)) {
            return this.localName;
        }
        return this.prefix + ':' + this.localName;
    }

    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public Class<?> getType(EvaluationContext ctx) throws ExpressionException {
        FunctionMapper fnMapper = ctx.getFunctionMapper();
        if (fnMapper == null) {
            throw new ExpressionException("Expression uses functions, but no FunctionMapper was provided");
        }
        Method m = fnMapper.resolveFunction(this.prefix, this.localName);
        if (m == null) {
            throw new ExpressionException("Function ''" + this.getOutputName() + "'' not found");
        }
        return m.getReturnType();
    }

    private Object findValue(EvaluationContext ctx, String name) {
        ValueExpression expr;
        if (ctx.isLambdaArgument(name)) {
            return ctx.getLambdaArgument(name);
        }
        VariableMapper varMapper = ctx.getVariableMapper();
        if (varMapper != null && (expr = varMapper.resolveVariable(name)) != null) {
            return expr.getValue(ctx);
        }
        ctx.setPropertyResolved(false);
        Object ret = ctx.getResolver().getValue(ctx, null, name);
        if (ctx.isPropertyResolved()) {
            return ret;
        }
        return null;
    }

    @Override
    public Object getValue(EvaluationContext ctx) throws ExpressionException {
        Object val;
        Node[] children = this.children;
        String localName = this.localName;
        if (this.prefix.isEmpty() && (val = this.findValue(ctx, localName)) instanceof LambdaExpression) {
            for (Node child : children) {
                Object[] params = ((AstMethodArguments)child).getParameters(ctx);
                if (!(val instanceof LambdaExpression)) {
                    throw new ExpressionException("Syntax error in calling function ''" + this.getOutputName() + "''");
                }
                val = ((LambdaExpression)val).invoke(ctx, params);
            }
            return val;
        }
        FunctionMapper fnMapper = ctx.getFunctionMapper();
        Method m = fnMapper.resolveFunction(this.prefix, localName);
        if (m == null) {
            if (this.prefix.isEmpty() && ctx.getImportHandler() != null) {
                Class<?> c = ctx.getImportHandler().resolveClass(localName);
                String methodName = null;
                if (c != null) {
                    methodName = "<init>";
                } else {
                    c = ctx.getImportHandler().resolveStatic(localName);
                    methodName = localName;
                }
                if (c != null) {
                    Object[] params = ((AstMethodArguments)children[0]).getParameters(ctx);
                    return ctx.getResolver().invoke(ctx, c, methodName, null, params);
                }
            }
            throw new ExpressionException("Function ''" + this.getOutputName() + "'' not found");
        }
        Class<?>[] paramTypes = m.getParameterTypes();
        Object[] params = ((AstMethodArguments)children[0]).getParameters(ctx);
        try {
            for (int i = 0; i < params.length; ++i) {
                params[i] = ctx.convertToType(params[i], paramTypes[i]);
            }
        }
        catch (ExpressionException ele) {
            throw new ExpressionException("Problems calling function '" + this.getOutputName() + "'", ele);
        }
        try {
            return m.invoke(null, params);
        }
        catch (IllegalAccessException iae) {
            throw new ExpressionException("Problems calling function '" + this.getOutputName() + "'", iae);
        }
        catch (InvocationTargetException ite) {
            throw new ExpressionException("Problems calling function '" + this.getOutputName() + "'", ite.getCause());
        }
    }

    public void setLocalName(String localName) {
        this.localName = localName;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    @Override
    public String toString() {
        return ELParserTreeConstants.NODE_NAME[this.id] + "[" + this.getOutputName() + "]";
    }
}

