/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.expression.lang;

import cn.taketoday.context.utils.NumberUtils;
import cn.taketoday.expression.lang.ExpressionUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;

public abstract class ExpressionArithmetic
extends ExpressionUtils {
    public static final LongDelegate LONG = new LongDelegate();
    public static final DoubleDelegate DOUBLE = new DoubleDelegate();
    public static final BigDecimalDelegate BIGDECIMAL = new BigDecimalDelegate();
    public static final BigIntegerDelegate BIGINTEGER = new BigIntegerDelegate();
    private static final ExpressionArithmetic[] EXPRESSION_ARITHMETICS = new ExpressionArithmetic[]{BIGDECIMAL, DOUBLE, BIGINTEGER};

    protected ExpressionArithmetic() {
    }

    public static Number add(Object obj0, Object obj1) {
        return ExpressionArithmetic.operation(obj0, obj1, ExpressionArithmetic::addInternal);
    }

    public static Number mod(Object obj0, Object obj1) {
        return ExpressionArithmetic.operation(obj0, obj1, ExpressionArithmetic::modInternal);
    }

    public static Number subtract(Object obj0, Object obj1) {
        return ExpressionArithmetic.operation(obj0, obj1, ExpressionArithmetic::subtractInternal);
    }

    public static Number multiply(Object obj0, Object obj1) {
        return ExpressionArithmetic.operation(obj0, obj1, ExpressionArithmetic::multiplyInternal);
    }

    public static Number divide(Object obj0, Object obj1) {
        if (obj0 == null && obj1 == null) {
            return ZERO;
        }
        ExpressionArithmetic delegate = BIGDECIMAL.matches(obj0, obj1) ? BIGDECIMAL : (BIGINTEGER.matches(obj0, obj1) ? BIGDECIMAL : DOUBLE);
        return delegate.divideInternal(delegate.convert(obj0), delegate.convert(obj1));
    }

    public static boolean isNumber(Object obj) {
        return obj != null && NumberUtils.isNumber(obj.getClass());
    }

    protected static Number operation(Object obj0, Object obj1, Operation operation) {
        if (obj0 == null && obj1 == null) {
            return ZERO;
        }
        for (ExpressionArithmetic arithmetic : EXPRESSION_ARITHMETICS) {
            if (!arithmetic.matches(obj0, obj1)) continue;
            return operation.apply(arithmetic, arithmetic.convert(obj0), arithmetic.convert(obj1));
        }
        LongDelegate arithmetic = LONG;
        return operation.apply(arithmetic, arithmetic.convert(obj0), arithmetic.convert(obj1));
    }

    protected abstract Number convert(Number var1);

    protected abstract Number convert(String var1);

    protected abstract Number modInternal(Number var1, Number var2);

    protected abstract Number addInternal(Number var1, Number var2);

    protected abstract Number divideInternal(Number var1, Number var2);

    protected abstract Number multiplyInternal(Number var1, Number var2);

    protected abstract Number subtractInternal(Number var1, Number var2);

    protected abstract boolean matches(Object var1, Object var2);

    protected final Number convert(Object obj) {
        if (obj == null) {
            return this.convert(ZERO);
        }
        if (ExpressionArithmetic.isNumber(obj)) {
            return this.convert((Number)obj);
        }
        if (obj instanceof String) {
            return "".equals(obj) ? (Number)this.convert(ZERO) : (Number)this.convert((String)obj);
        }
        Class<?> objType = obj.getClass();
        if (objType == Character.class || objType == Character.TYPE) {
            return this.convert((short)((Character)obj).charValue());
        }
        throw new IllegalArgumentException("Cannot convert " + obj + " of type " + objType + " to Number");
    }

    public static final class LongDelegate
    extends ExpressionArithmetic {
        @Override
        protected Number addInternal(Number num0, Number num1) {
            return num0.longValue() + num1.longValue();
        }

        @Override
        protected Number convert(Number num) {
            return num.longValue();
        }

        @Override
        protected Number convert(String str) {
            return Long.parseLong(str);
        }

        @Override
        protected Number divideInternal(Number num0, Number num1) {
            return num0.longValue() / num1.longValue();
        }

        @Override
        protected Number modInternal(Number num0, Number num1) {
            return num0.longValue() % num1.longValue();
        }

        @Override
        protected Number subtractInternal(Number num0, Number num1) {
            return num0.longValue() - num1.longValue();
        }

        @Override
        protected Number multiplyInternal(Number num0, Number num1) {
            return num0.longValue() * num1.longValue();
        }

        @Override
        public boolean matches(Object obj0, Object obj1) {
            return obj0 instanceof Long || obj1 instanceof Long;
        }
    }

    static class DoubleDelegate
    extends ExpressionArithmetic {
        DoubleDelegate() {
        }

        @Override
        protected Number addInternal(Number num0, Number num1) {
            if (num0 instanceof BigDecimal) {
                return ((BigDecimal)num0).add(BigDecimal.valueOf(num1.doubleValue()));
            }
            if (num1 instanceof BigDecimal) {
                return BigDecimal.valueOf(num0.doubleValue()).add((BigDecimal)num1);
            }
            return num0.doubleValue() + num1.doubleValue();
        }

        @Override
        protected Number convert(Number num) {
            if (num instanceof Double) {
                return num;
            }
            if (num instanceof BigInteger) {
                return new BigDecimal((BigInteger)num);
            }
            return num.doubleValue();
        }

        @Override
        protected Number convert(String str) {
            return Double.parseDouble(str);
        }

        @Override
        protected Number divideInternal(Number num0, Number num1) {
            return num0.doubleValue() / num1.doubleValue();
        }

        @Override
        protected Number modInternal(Number num0, Number num1) {
            return num0.doubleValue() % num1.doubleValue();
        }

        @Override
        protected Number subtractInternal(Number num0, Number num1) {
            if (num0 instanceof BigDecimal) {
                return ((BigDecimal)num0).subtract(BigDecimal.valueOf(num1.doubleValue()));
            }
            if (num1 instanceof BigDecimal) {
                return BigDecimal.valueOf(num0.doubleValue()).subtract((BigDecimal)num1);
            }
            return num0.doubleValue() - num1.doubleValue();
        }

        @Override
        protected Number multiplyInternal(Number num0, Number num1) {
            if (num0 instanceof BigDecimal) {
                return ((BigDecimal)num0).multiply(BigDecimal.valueOf(num1.doubleValue()));
            }
            if (num1 instanceof BigDecimal) {
                return BigDecimal.valueOf(num0.doubleValue()).multiply((BigDecimal)num1);
            }
            return num0.doubleValue() * num1.doubleValue();
        }

        @Override
        public boolean matches(Object obj0, Object obj1) {
            return obj0 instanceof Double || obj1 instanceof Double || obj0 instanceof Float || obj1 instanceof Float || obj0 != null && (Double.TYPE == obj0.getClass() || Float.TYPE == obj0.getClass()) || obj1 != null && (Double.TYPE == obj1.getClass() || Float.TYPE == obj1.getClass()) || obj0 instanceof String && ExpressionUtils.isStringFloat((String)obj0) || obj1 instanceof String && ExpressionUtils.isStringFloat((String)obj1);
        }
    }

    static class BigIntegerDelegate
    extends ExpressionArithmetic {
        BigIntegerDelegate() {
        }

        @Override
        protected Number addInternal(Number num0, Number num1) {
            return ((BigInteger)num0).add((BigInteger)num1);
        }

        @Override
        protected Number convert(Number num) {
            return num instanceof BigInteger ? num : new BigInteger(num.toString());
        }

        @Override
        protected Number convert(String str) {
            return new BigInteger(str);
        }

        @Override
        protected Number divideInternal(Number num0, Number num1) {
            return new BigDecimal((BigInteger)num0).divide(new BigDecimal((BigInteger)num1), RoundingMode.HALF_UP);
        }

        @Override
        protected Number multiplyInternal(Number num0, Number num1) {
            return ((BigInteger)num0).multiply((BigInteger)num1);
        }

        @Override
        protected Number modInternal(Number num0, Number num1) {
            return ((BigInteger)num0).mod((BigInteger)num1);
        }

        @Override
        protected Number subtractInternal(Number num0, Number num1) {
            return ((BigInteger)num0).subtract((BigInteger)num1);
        }

        @Override
        public boolean matches(Object obj0, Object obj1) {
            return obj0 instanceof BigInteger || obj1 instanceof BigInteger;
        }
    }

    static final class BigDecimalDelegate
    extends ExpressionArithmetic {
        BigDecimalDelegate() {
        }

        @Override
        protected Number addInternal(Number num0, Number num1) {
            return ((BigDecimal)num0).add((BigDecimal)num1);
        }

        @Override
        protected Number convert(Number num) {
            if (num instanceof BigDecimal) {
                return num;
            }
            return num instanceof BigInteger ? new BigDecimal((BigInteger)num) : BigDecimal.valueOf(num.doubleValue());
        }

        @Override
        protected Number convert(String str) {
            return new BigDecimal(str);
        }

        @Override
        protected Number divideInternal(Number num0, Number num1) {
            return ((BigDecimal)num0).divide((BigDecimal)num1, 4);
        }

        @Override
        protected Number subtractInternal(Number num0, Number num1) {
            return ((BigDecimal)num0).subtract((BigDecimal)num1);
        }

        @Override
        protected Number modInternal(Number num0, Number num1) {
            return num0.doubleValue() % num1.doubleValue();
        }

        @Override
        protected Number multiplyInternal(Number num0, Number num1) {
            return ((BigDecimal)num0).multiply((BigDecimal)num1);
        }

        @Override
        public boolean matches(Object obj0, Object obj1) {
            return obj0 instanceof BigDecimal || obj1 instanceof BigDecimal;
        }
    }

    static interface Operation {
        public Number apply(ExpressionArithmetic var1, Number var2, Number var3);
    }
}

