/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.expression;

import cn.taketoday.expression.ExpressionContext;
import cn.taketoday.expression.ExpressionException;
import cn.taketoday.expression.MethodExpression;
import cn.taketoday.expression.MethodInfo;

public class MethodExpressionLiteral
extends MethodExpression {
    private final String expr;
    private final Class<?> expectedType;
    private final Class<?>[] paramTypes;

    public MethodExpressionLiteral() {
        this(null, null, null);
    }

    public MethodExpressionLiteral(String expr, Class<?> expectedType, Class<?>[] paramTypes) {
        this.expr = expr;
        this.expectedType = expectedType;
        this.paramTypes = paramTypes;
    }

    @Override
    public MethodInfo getMethodInfo(ExpressionContext context) throws ExpressionException {
        return new MethodInfo(this.expr, this.expectedType, this.paramTypes);
    }

    @Override
    public Object invoke(ExpressionContext context, Object[] params) throws ExpressionException {
        if (this.expectedType == null) {
            return this.expr;
        }
        try {
            return context.convertToType(this.expr, this.expectedType);
        }
        catch (Exception ex) {
            throw new ExpressionException(ex);
        }
    }

    @Override
    public String getExpressionString() {
        return this.expr;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof MethodExpressionLiteral && this.hashCode() == obj.hashCode();
    }

    @Override
    public int hashCode() {
        return this.expr.hashCode();
    }

    @Override
    public boolean isLiteralText() {
        return true;
    }
}

