/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.expression;

import cn.taketoday.expression.ExpressionContext;
import cn.taketoday.expression.ExpressionException;
import cn.taketoday.expression.ExpressionFactory;
import cn.taketoday.expression.MethodExpression;
import cn.taketoday.expression.MethodInfo;
import cn.taketoday.expression.MethodNotFoundException;
import cn.taketoday.expression.PropertyNotFoundException;
import cn.taketoday.expression.lang.EvaluationContext;
import cn.taketoday.expression.parser.Node;

public final class MethodExpressionImpl
extends MethodExpression {
    private Node node;
    private final String expr;
    private final Class<?>[] paramTypes;
    private final Class<?> expectedType;

    public MethodExpressionImpl() {
        this(null, null, null, null);
    }

    public MethodExpressionImpl(String expr, Node node, Class<?>[] paramTypes, Class<?> expectedType) {
        this.expr = expr;
        this.node = node;
        this.paramTypes = paramTypes;
        this.expectedType = expectedType;
    }

    @Override
    public String getExpressionString() {
        return this.expr;
    }

    @Override
    public MethodInfo getMethodInfo(ExpressionContext context) throws PropertyNotFoundException, MethodNotFoundException, ExpressionException {
        return this.getNode().getMethodInfo(new EvaluationContext(context), this.paramTypes);
    }

    private final Node getNode() throws ExpressionException {
        Node node = this.node;
        if (node == null) {
            this.node = ExpressionFactory.createNode(this.expr);
            return this.node;
        }
        return node;
    }

    @Override
    public int hashCode() {
        return this.getNode().hashCode();
    }

    @Override
    public Object invoke(ExpressionContext context, Object[] params) throws PropertyNotFoundException, MethodNotFoundException, ExpressionException {
        Object value = this.getNode().invoke(new EvaluationContext(context), this.paramTypes, params);
        Class<?> expectedType = this.expectedType;
        if (value != null && expectedType != null && !expectedType.isInstance(value)) {
            try {
                value = context.convertToType(value, expectedType);
            }
            catch (IllegalArgumentException ex) {
                throw new ExpressionException(ex);
            }
        }
        return value;
    }

    @Override
    public boolean isLiteralText() {
        return false;
    }

    @Override
    public boolean isParametersProvided() {
        return this.getNode().isParametersProvided();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof MethodExpressionImpl) {
            MethodExpressionImpl me = (MethodExpressionImpl)obj;
            return this.getNode().equals(me.getNode());
        }
        return false;
    }
}

