/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.expression;

import cn.taketoday.expression.ExpressionContext;
import cn.taketoday.expression.ExpressionResolver;
import cn.taketoday.expression.PropertyNotWritableException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class MapExpressionResolver
extends ExpressionResolver {
    private static Class<?> theUnmodifiableMapClass = Collections.unmodifiableMap(new HashMap()).getClass();
    private boolean isReadOnly;

    public MapExpressionResolver() {
        this.isReadOnly = false;
    }

    public MapExpressionResolver(boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
    }

    @Override
    public Class<?> getType(ExpressionContext context, Object base, Object property) {
        Objects.requireNonNull(context);
        if (base instanceof Map) {
            context.setPropertyResolved(true);
            return Object.class;
        }
        return null;
    }

    @Override
    public Object getValue(ExpressionContext context, Object base, Object property) {
        if (base instanceof Map) {
            Objects.requireNonNull(context).setPropertyResolved(base, property);
            return ((Map)base).get(property);
        }
        return null;
    }

    @Override
    public void setValue(ExpressionContext context, Object base, Object property, Object val) {
        Objects.requireNonNull(context);
        if (base instanceof Map) {
            context.setPropertyResolved(base, property);
            Map map = (Map)base;
            if (this.isReadOnly || map.getClass() == theUnmodifiableMapClass) {
                throw new PropertyNotWritableException();
            }
            try {
                map.put(property, val);
            }
            catch (UnsupportedOperationException ex) {
                throw new PropertyNotWritableException();
            }
        }
    }

    @Override
    public boolean isReadOnly(ExpressionContext context, Object base, Object property) {
        Objects.requireNonNull(context);
        if (base instanceof Map) {
            context.setPropertyResolved(true);
            return this.isReadOnly || ((Map)base).getClass() == theUnmodifiableMapClass;
        }
        return false;
    }
}

