/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.reflect;

import cn.taketoday.context.reflect.GetterMethod;
import cn.taketoday.context.reflect.PropertyAccessor;
import cn.taketoday.context.reflect.SetterMethod;
import cn.taketoday.context.utils.Assert;
import java.lang.reflect.Method;

public class GetterSetterPropertyAccessor
implements PropertyAccessor {
    private final GetterMethod readMethod;
    private final SetterMethod writeMethod;

    public GetterSetterPropertyAccessor(GetterMethod readMethod, SetterMethod writeMethod) {
        Assert.notNull((Object)readMethod, "readMethod must not be null");
        Assert.notNull((Object)writeMethod, "writeMethod must not be null");
        this.readMethod = readMethod;
        this.writeMethod = writeMethod;
    }

    @Override
    public Object get(Object obj) {
        return this.readMethod.get(obj);
    }

    @Override
    public void set(Object obj, Object value) {
        this.writeMethod.set(obj, value);
    }

    @Override
    public Method getReadMethod() {
        return this.readMethod.getReadMethod();
    }

    @Override
    public Method getWriteMethod() {
        return this.writeMethod.getWriteMethod();
    }
}

