/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.reflect;

import cn.taketoday.context.asm.ClassVisitor;
import cn.taketoday.context.asm.Type;
import cn.taketoday.context.cglib.core.CglibReflectUtils;
import cn.taketoday.context.cglib.core.ClassEmitter;
import cn.taketoday.context.cglib.core.ClassGenerator;
import cn.taketoday.context.cglib.core.CodeEmitter;
import cn.taketoday.context.cglib.core.CodeGenerationException;
import cn.taketoday.context.cglib.core.DefaultGeneratorStrategy;
import cn.taketoday.context.cglib.core.EmitUtils;
import cn.taketoday.context.cglib.core.TypeUtils;
import cn.taketoday.context.reflect.Accessor;
import cn.taketoday.context.utils.Assert;
import cn.taketoday.context.utils.ClassUtils;
import cn.taketoday.context.utils.Mappings;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;

public abstract class GeneratorSupport<T extends Accessor> {
    static final Type GENERATOR_SUPPORT_TYPE = Type.getType(GeneratorSupport.class);
    static final String GENERATOR_SUPPORT_TYPE_INTERNAL_NAME = GENERATOR_SUPPORT_TYPE.getInternalName();
    static final String DEFAULT_SUPER = "Ljava/lang/Object;";
    protected String className;
    protected ClassLoader classLoader;
    protected final Class<?> targetClass;
    protected static final Mappings<Accessor, GeneratorSupport<?>> mappings = new Mappings<Accessor, GeneratorSupport<?>>(){

        @Override
        protected Accessor createValue(Object key, GeneratorSupport<?> generator) {
            try {
                return generator.createInternal();
            }
            catch (Exception e) {
                return generator.fallback(e);
            }
        }
    };

    protected GeneratorSupport(Class<?> targetClass) {
        Assert.notNull(targetClass, "targetClass must not be null");
        this.targetClass = targetClass;
    }

    public T create() {
        Object cacheKey = this.cacheKey();
        return (T)mappings.get(cacheKey, this);
    }

    protected T fallback(Exception exception) {
        if (exception instanceof InvocationTargetException ? ((InvocationTargetException)exception).getTargetException() instanceof SecurityException : exception instanceof SecurityException) {
            return this.fallbackInstance();
        }
        throw new CodeGenerationException(exception);
    }

    protected T createInternal() throws Exception {
        if (this.cannotAccess()) {
            return this.fallbackInstance();
        }
        Class<T> accessorClass = this.generateIfNecessary(this.getClassLoader());
        return this.newInstance(accessorClass);
    }

    protected T newInstance(Class<T> accessorClass) throws Exception {
        Constructor<T> constructor = ClassUtils.obtainConstructor(accessorClass);
        return (T)((Accessor)ClassUtils.newInstance(constructor, null));
    }

    private Class<T> generateIfNecessary(ClassLoader classLoader) throws Exception {
        try {
            return classLoader.loadClass(this.getClassName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            byte[] bytes = DefaultGeneratorStrategy.INSTANCE.generate(this.getClassGenerator());
            return CglibReflectUtils.defineClass(this.getClassName(), bytes, classLoader, CglibReflectUtils.getProtectionDomain(this.targetClass));
        }
    }

    protected abstract Object cacheKey();

    protected abstract T fallbackInstance();

    protected abstract boolean cannotAccess();

    protected ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            this.classLoader = this.targetClass.getClassLoader();
            if (this.classLoader == null) {
                this.classLoader = ClassUtils.getClassLoader();
            }
        }
        return this.classLoader;
    }

    protected abstract ClassGenerator getClassGenerator();

    protected String getClassName() {
        if (this.className == null) {
            this.className = this.createClassName();
        }
        return this.className;
    }

    protected abstract String createClassName();

    protected void buildClassNameSuffix(StringBuilder builder, Executable target) {
        if (target.getParameterCount() != 0) {
            for (Class<?> parameterType : target.getParameterTypes()) {
                builder.append('$');
                if (parameterType.isArray()) {
                    builder.append("A$");
                    Class<?> componentType = parameterType;
                    do {
                        String simpleName = componentType.getSimpleName();
                        builder.append(simpleName, 0, simpleName.indexOf(91));
                    } while ((componentType = componentType.getComponentType()) != null && componentType.isArray());
                    continue;
                }
                builder.append(parameterType.getSimpleName());
            }
        }
    }

    protected int getArgsIndex() {
        return 2;
    }

    protected void prepareParameters(CodeEmitter codeEmitter, Executable targetExecutable) {
        if (targetExecutable.getParameterCount() == 0) {
            return;
        }
        Class<?>[] parameterTypes = targetExecutable.getParameterTypes();
        int argsIndex = this.getArgsIndex();
        for (int i = 0; i < parameterTypes.length; ++i) {
            codeEmitter.visitVarInsn(25, argsIndex);
            codeEmitter.aaload(i);
            Class<?> parameterClass = parameterTypes[i];
            Type parameterType = Type.getType(parameterClass);
            if (parameterClass.isPrimitive()) {
                Type boxedType = TypeUtils.getBoxedType(parameterType);
                codeEmitter.checkcast(boxedType);
                String descriptor = boxedType.getDescriptor();
                codeEmitter.visitMethodInsn(184, GENERATOR_SUPPORT_TYPE_INTERNAL_NAME, "convert", '(' + descriptor + ')' + parameterType.getDescriptor(), false);
                continue;
            }
            codeEmitter.checkcast(parameterType);
        }
    }

    protected ClassEmitter beginClass(ClassVisitor v) {
        ClassEmitter ce = new ClassEmitter(v);
        ce.beginClass(17, this.getClassName().replace('.', '/'), this.getSuperType(), this.getInterfaces());
        this.generateConstructor(ce);
        return ce;
    }

    protected void generateConstructor(ClassEmitter ce) {
        EmitUtils.nullConstructor(ce);
    }

    protected String[] getInterfaces() {
        return null;
    }

    public String getSuperType() {
        return DEFAULT_SUPER;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public static long convert(Long value) {
        return value == null ? 0L : value;
    }

    public static int convert(Integer value) {
        return value == null ? 0 : value;
    }

    public static short convert(Short value) {
        return value == null ? (short)0 : value;
    }

    public static byte convert(Byte value) {
        return value == null ? (byte)0 : value;
    }

    public static float convert(Float value) {
        return value == null ? 0.0f : value.floatValue();
    }

    public static double convert(Double value) {
        return value == null ? 0.0 : value;
    }

    public static boolean convert(Boolean value) {
        return value != null && value != false;
    }

    public static char convert(Character value) {
        return value == null ? (char)'\u0000' : value.charValue();
    }
}

