/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.reflect;

import cn.taketoday.context.reflect.ConstructorAccessor;
import cn.taketoday.context.utils.Assert;
import cn.taketoday.context.utils.CollectionUtils;

public class CollectionConstructor
implements ConstructorAccessor {
    private int capacity = 0;
    private Class<?> elementType;
    private final Class<?> collectionType;

    public CollectionConstructor(Class<?> collectionType) {
        this(collectionType, null);
    }

    public CollectionConstructor(Class<?> collectionType, Class<?> elementType) {
        Assert.notNull(collectionType, "collection type must not be null");
        this.elementType = elementType;
        this.collectionType = collectionType;
    }

    @Override
    public Object newInstance(Object[] args) {
        return CollectionUtils.createCollection(this.collectionType, this.elementType, this.capacity);
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public void setElementType(Class<?> elementType) {
        this.elementType = elementType;
    }
}

