/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.reflect;

import cn.taketoday.context.reflect.ConstructorAccessor;
import cn.taketoday.context.utils.Assert;
import java.lang.reflect.Array;

public class ArrayConstructor
implements ConstructorAccessor {
    private int capacity = 0;
    private final Class<?> componentType;

    public ArrayConstructor(Class<?> componentType) {
        Assert.notNull(componentType, "component type must not be null");
        this.componentType = componentType;
    }

    @Override
    public Object newInstance(Object[] args) {
        Class<?> componentType = this.componentType;
        if (componentType.isArray()) {
            Object array = Array.newInstance(componentType, 1);
            Array.set(array, 0, Array.newInstance(componentType.getComponentType(), this.capacity));
            return array;
        }
        return Array.newInstance(componentType, this.capacity);
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }
}

