/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.logger;

import cn.taketoday.context.logger.AbstractLogger;
import cn.taketoday.context.logger.Level;
import cn.taketoday.context.logger.MessageFormatter;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class JavaLoggingLogger
extends AbstractLogger {
    private final Logger logger;
    protected static final String thisFQCN = JavaLoggingLogger.class.getName();

    public JavaLoggingLogger(String name) {
        this.logger = Logger.getLogger(name);
    }

    @Override
    public String getName() {
        return this.logger.getName();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isLoggable(java.util.logging.Level.FINEST);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isLoggable(java.util.logging.Level.FINER);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isLoggable(java.util.logging.Level.INFO);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isLoggable(java.util.logging.Level.WARNING);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isLoggable(java.util.logging.Level.SEVERE);
    }

    private final java.util.logging.Level levelToJavaLevel(Level level) {
        switch (level) {
            case TRACE: {
                return java.util.logging.Level.FINEST;
            }
            case DEBUG: {
                return java.util.logging.Level.FINER;
            }
            case WARN: {
                return java.util.logging.Level.WARNING;
            }
            case ERROR: {
                return java.util.logging.Level.SEVERE;
            }
        }
        return java.util.logging.Level.INFO;
    }

    @Override
    protected void logInternal(Level level, String format, Throwable t, Object[] args) {
        java.util.logging.Level levelToJavaLevel = this.levelToJavaLevel(level);
        if (this.logger.isLoggable(levelToJavaLevel)) {
            LogRecord record = new LogRecord(levelToJavaLevel, MessageFormatter.format(format, args));
            record.setLoggerName(this.getName());
            record.setThrown(t);
            JavaLoggingLogger.fillCallerData(record, thisFQCN, FQCN);
            this.logger.log(record);
        }
    }

    private static void fillCallerData(LogRecord record, String callerFQCN, String superFQCN) {
        StackTraceElement[] steArray = new Throwable().getStackTrace();
        int selfIndex = -1;
        for (int i = 0; i < steArray.length; ++i) {
            String className = steArray[i].getClassName();
            if (!className.equals(callerFQCN) && !className.equals(superFQCN)) continue;
            selfIndex = i;
            break;
        }
        int found = -1;
        for (int i = selfIndex + 1; i < steArray.length; ++i) {
            String className = steArray[i].getClassName();
            if (className.equals(callerFQCN) || className.equals(superFQCN)) continue;
            found = i;
            break;
        }
        if (found != -1) {
            StackTraceElement ste = steArray[found];
            record.setSourceClassName(ste.getClassName());
            record.setSourceMethodName(ste.getMethodName());
        }
    }
}

