/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.loader;

import cn.taketoday.context.ApplicationContext;
import cn.taketoday.context.ExpressionEvaluator;
import cn.taketoday.context.annotation.Env;
import cn.taketoday.context.annotation.Required;
import cn.taketoday.context.annotation.Value;
import cn.taketoday.context.aware.OrderedApplicationContextSupport;
import cn.taketoday.context.exception.ConfigurationException;
import cn.taketoday.context.factory.DefaultPropertySetter;
import cn.taketoday.context.loader.PropertyValueResolver;
import cn.taketoday.context.utils.ClassUtils;
import cn.taketoday.context.utils.StringUtils;
import java.lang.reflect.Field;

public class ValuePropertyResolver
extends OrderedApplicationContextSupport
implements PropertyValueResolver {
    private ExpressionEvaluator expressionEvaluator;

    public ValuePropertyResolver(ApplicationContext context) {
        this(context, 0x3FFFFFFE);
    }

    public ValuePropertyResolver(ApplicationContext context, int order) {
        super(order);
        this.setApplicationContext(context);
    }

    @Override
    public boolean supportsProperty(Field field) {
        return ClassUtils.isAnnotationPresent(field, Value.class) || ClassUtils.isAnnotationPresent(field, Env.class);
    }

    @Override
    protected void initApplicationContext(ApplicationContext context) {
        super.initApplicationContext(context);
        this.expressionEvaluator = new ExpressionEvaluator(context);
    }

    @Override
    public DefaultPropertySetter resolveProperty(Field field) {
        Object resolved;
        String expression;
        Value value = ClassUtils.getAnnotation(Value.class, field);
        if (value != null) {
            expression = value.value();
        } else {
            Env env = ClassUtils.getAnnotation(Env.class, field);
            expression = env.value();
            if (StringUtils.isNotEmpty(expression)) {
                expression = new StringBuilder(expression.length() + 3).append("#{").append(expression).append('}').toString();
            }
        }
        if (StringUtils.isEmpty(expression)) {
            expression = "#{" + field.getDeclaringClass().getName() + '.' + field.getName() + '}';
        }
        try {
            resolved = this.expressionEvaluator.evaluate(expression, field.getType());
        }
        catch (ConfigurationException e) {
            return this.fallback(field, expression, e);
        }
        if (resolved == null) {
            return this.fallback(field, expression, null);
        }
        return new DefaultPropertySetter(resolved, field);
    }

    private DefaultPropertySetter fallback(Field field, String expression, ConfigurationException e) {
        boolean required;
        Env env = ClassUtils.getAnnotation(Env.class, field);
        if (env == null) {
            Value value = ClassUtils.getAnnotation(Value.class, field);
            required = value.required();
        } else {
            required = env.required();
        }
        if (required || ClassUtils.isAnnotationPresent(field, Required.class)) {
            throw new ConfigurationException("Can't resolve field: [" + field + "] -> [" + expression + "].", e);
        }
        return null;
    }
}

