/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.loader;

import cn.taketoday.context.OrderedSupport;
import cn.taketoday.context.exception.ConfigurationException;
import cn.taketoday.context.factory.BeanFactory;
import cn.taketoday.context.loader.ExecutableParameterResolver;
import cn.taketoday.context.utils.CollectionUtils;
import cn.taketoday.context.utils.ResolvableType;
import java.lang.reflect.Parameter;
import java.util.Collection;
import java.util.Map;

public class CollectionParameterResolver
extends OrderedSupport
implements ExecutableParameterResolver {
    public CollectionParameterResolver() {
        this(Integer.MAX_VALUE);
    }

    public CollectionParameterResolver(int order) {
        super(order);
    }

    @Override
    public boolean supports(Parameter parameter) {
        return Collection.class.isAssignableFrom(parameter.getType());
    }

    @Override
    public Object resolve(Parameter parameter, BeanFactory beanFactory) {
        ResolvableType parameterType = ResolvableType.forParameter(parameter);
        if (parameterType.hasGenerics()) {
            ResolvableType type = parameterType.asCollection().getGeneric(0);
            Map<String, ?> beans = beanFactory.getBeansOfType(type.toClass());
            Collection<?> objects = CollectionUtils.createCollection(parameter.getType(), beans.size());
            objects.addAll(beans.values());
            return objects;
        }
        throw new ConfigurationException("Not Support " + parameter);
    }
}

