/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.io;

import cn.taketoday.context.io.AbstractResource;
import cn.taketoday.context.utils.ResourceUtils;
import cn.taketoday.context.utils.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Objects;

public class UrlBasedResource
extends AbstractResource {
    private final URL url;

    public UrlBasedResource(URL url) {
        this.url = Objects.requireNonNull(url, "Url must not be null");
    }

    public UrlBasedResource(URI uri) throws MalformedURLException {
        this(uri.toURL());
    }

    public UrlBasedResource(String path) throws MalformedURLException {
        this(new URL(StringUtils.cleanPath(path)));
    }

    public UrlBasedResource(String protocol, String location) throws URISyntaxException, MalformedURLException {
        this(new URI(protocol, location, null).toURL());
    }

    @Override
    public InputStream getInputStream() throws IOException {
        URLConnection con = this.url.openConnection();
        ResourceUtils.useCachesIfNecessary(con);
        try {
            return con.getInputStream();
        }
        catch (IOException ex) {
            if (con instanceof HttpURLConnection) {
                ((HttpURLConnection)con).disconnect();
            }
            throw ex;
        }
    }

    @Override
    public URL getLocation() {
        return this.url;
    }

    @Override
    public File getFile() {
        return new File(this.url.getPath());
    }

    @Override
    public boolean equals(Object other) {
        return this == other || other instanceof UrlBasedResource && this.url.equals(((UrlBasedResource)other).url);
    }

    @Override
    public int hashCode() {
        return this.url.hashCode();
    }

    @Override
    public UrlBasedResource createRelative(String relativePath) throws IOException {
        return new UrlBasedResource(this.createRelativeURL(relativePath));
    }

    protected URL createRelativeURL(String relativePath) throws MalformedURLException {
        String relativePathToUse = relativePath;
        if (relativePathToUse.startsWith("/")) {
            relativePathToUse = relativePathToUse.substring(1);
        }
        relativePathToUse = StringUtils.replace(relativePathToUse, "#", "%23");
        return new URL(this.url, relativePathToUse);
    }

    @Override
    public String toString() {
        return "UrlBasedResource: ".concat(this.url.toString());
    }
}

