/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.io;

import cn.taketoday.context.AntPathMatcher;
import cn.taketoday.context.Constant;
import cn.taketoday.context.PathMatcher;
import cn.taketoday.context.io.ClassPathResource;
import cn.taketoday.context.io.FileBasedResource;
import cn.taketoday.context.io.JarEntryResource;
import cn.taketoday.context.io.JarResource;
import cn.taketoday.context.io.Resource;
import cn.taketoday.context.io.ResourceResolver;
import cn.taketoday.context.logger.Logger;
import cn.taketoday.context.logger.LoggerFactory;
import cn.taketoday.context.utils.Assert;
import cn.taketoday.context.utils.ClassUtils;
import cn.taketoday.context.utils.ObjectUtils;
import cn.taketoday.context.utils.ResourceUtils;
import cn.taketoday.context.utils.StringUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class PathMatchingResourcePatternResolver
implements ResourceResolver {
    private static final Logger log = LoggerFactory.getLogger(PathMatchingResourcePatternResolver.class);
    private ClassLoader classLoader;
    private PathMatcher pathMatcher = new AntPathMatcher();

    public PathMatchingResourcePatternResolver() {
        this(ClassUtils.getClassLoader());
    }

    public PathMatchingResourcePatternResolver(ClassLoader classLoader) {
        this.classLoader = classLoader == null ? ClassUtils.getClassLoader() : classLoader;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setPathMatcher(PathMatcher pathMatcher) {
        Assert.notNull((Object)pathMatcher, "PathMatcher must not be null");
        this.pathMatcher = pathMatcher;
    }

    public PathMatcher getPathMatcher() {
        return this.pathMatcher;
    }

    @Override
    public Resource getResource(String location) {
        return ResourceUtils.getResource(location);
    }

    @Override
    public Resource[] getResources(String locationPattern) throws IOException {
        int prefixEnd;
        Assert.notNull((Object)locationPattern, "Location pattern must not be null");
        if (locationPattern.startsWith("classpath*:")) {
            if (this.getPathMatcher().isPattern(locationPattern.substring("classpath*:".length()))) {
                return this.findPathMatchingResources(locationPattern);
            }
            return this.findAllClassPathResources(locationPattern.substring("classpath*:".length()));
        }
        int n = prefixEnd = locationPattern.startsWith("war:") ? locationPattern.indexOf("*/") : locationPattern.indexOf(58);
        if (this.getPathMatcher().isPattern(locationPattern.substring(prefixEnd + 1))) {
            return this.findPathMatchingResources(locationPattern);
        }
        return new Resource[]{this.getResource(locationPattern)};
    }

    protected Resource[] findAllClassPathResources(String location) throws IOException {
        Set<Resource> result;
        String path = location;
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (ObjectUtils.isEmpty(result = this.doFindAllClassPathResources(path))) {
            return Constant.EMPTY_RESOURCE_ARRAY;
        }
        if (log.isTraceEnabled()) {
            log.trace("Resolved classpath location [{}] to resources {}", (Object)location, (Object)result);
        }
        return result.toArray(new Resource[result.size()]);
    }

    protected Set<Resource> doFindAllClassPathResources(String path) throws IOException {
        Enumeration<URL> resourceUrls;
        LinkedHashSet<Resource> result = new LinkedHashSet<Resource>();
        ClassLoader cl = this.getClassLoader();
        Enumeration<URL> enumeration = resourceUrls = cl != null ? cl.getResources(path) : ClassLoader.getSystemResources(path);
        while (resourceUrls.hasMoreElements()) {
            result.add(this.convertClassLoaderURL(resourceUrls.nextElement()));
        }
        if ("".equals(path)) {
            this.addAllClassLoaderJarRoots(cl, result);
        }
        return result;
    }

    protected Resource convertClassLoaderURL(URL url) {
        return ResourceUtils.getResource(url);
    }

    protected void addAllClassLoaderJarRoots(ClassLoader classLoader, Set<Resource> result) {
        if (classLoader instanceof URLClassLoader) {
            try {
                String jar = ".jar";
                for (URL url : ((URLClassLoader)classLoader).getURLs()) {
                    try {
                        JarEntryResource jarResource;
                        String path = url.getPath();
                        if (!path.endsWith(".jar") || !(jarResource = new JarEntryResource(path)).exists()) continue;
                        result.add(jarResource);
                    }
                    catch (IOException ex) {
                        log.debug("Cannot search for matching files underneath [{}] because it cannot be converted to a valid 'jar:' URL: {}", (Object)url, (Object)ex.getMessage());
                    }
                }
            }
            catch (Exception ex) {
                log.debug("Cannot introspect jar files since ClassLoader [{}] does not support 'getURLs()': {}", (Object)classLoader, (Object)ex);
            }
        }
        if (classLoader == ClassLoader.getSystemClassLoader()) {
            this.addClassPathManifestEntries(result);
        }
        if (classLoader != null) {
            try {
                this.addAllClassLoaderJarRoots(classLoader.getParent(), result);
            }
            catch (Exception ex) {
                log.debug("Cannot introspect jar files in parent ClassLoader since [{}] does not support 'getParent()': {}", classLoader, ex.toString(), ex);
            }
        }
    }

    protected void addClassPathManifestEntries(Set<Resource> result) {
        try {
            String javaClassPath = System.getProperty("java.class.path");
            String separator = System.getProperty("path.separator");
            for (String path : StringUtils.delimitedListToStringArray(javaClassPath, separator)) {
                try {
                    String url;
                    JarEntryResource jarResource;
                    if (!path.endsWith(".jar")) continue;
                    File jarFile = new File(path);
                    String filePath = jarFile.getAbsolutePath();
                    int prefixIndex = filePath.indexOf(58);
                    if (prefixIndex == 1) {
                        filePath = StringUtils.capitalize(filePath);
                    }
                    if (result.contains(jarResource = new JarEntryResource(new URL(url = new StringBuilder(filePath.length() + 11).append("jar:file:").append(filePath).append("!/").toString()), jarFile, "")) || this.hasDuplicate(filePath, result) || !jarFile.exists()) continue;
                    result.add(jarResource);
                }
                catch (MalformedURLException ex) {
                    log.debug("Cannot search for matching files underneath [{}] because it cannot be converted to a valid 'jar:' URL: {}", path, ex.getMessage(), ex);
                }
            }
        }
        catch (Exception ex) {
            log.debug("Failed to evaluate 'java.class.path' manifest entries: ", ex);
        }
    }

    private boolean hasDuplicate(String filePath, Set<Resource> result) {
        if (result.isEmpty()) {
            return false;
        }
        String duplicatePath = filePath.startsWith("/") ? filePath.substring(1) : "/".concat(filePath);
        try {
            return result.contains(new JarEntryResource(new StringBuilder(duplicatePath.length() + 11).append("jar:file:").append(duplicatePath).append("!/").toString()));
        }
        catch (IOException ex) {
            return false;
        }
    }

    protected Resource[] findPathMatchingResources(String locationPattern) throws IOException {
        String rootDirPath = this.determineRootDir(locationPattern);
        String subPattern = locationPattern.substring(rootDirPath.length());
        Resource[] rootDirResources = this.getResources(rootDirPath);
        LinkedHashSet<Resource> result = new LinkedHashSet<Resource>();
        for (Resource rootDirResource : rootDirResources) {
            this.rootDirResource(subPattern, result, rootDirResource);
        }
        if (log.isTraceEnabled()) {
            log.trace("Resolved location pattern [{}] to resources {}", (Object)locationPattern, (Object)result);
        }
        return result.toArray(new Resource[result.size()]);
    }

    protected void rootDirResource(String subPattern, Set<Resource> result, Resource rootResource) throws IOException {
        if (rootResource instanceof JarResource) {
            result.addAll(this.doFindPathMatchingJarResources((JarResource)rootResource, subPattern));
        } else if (rootResource instanceof FileBasedResource) {
            result.addAll(this.doFindPathMatchingFileResources(rootResource, subPattern));
        } else if (rootResource instanceof ClassPathResource) {
            Resource originalResource = ((ClassPathResource)rootResource).getOriginalResource();
            this.rootDirResource(subPattern, result, originalResource);
        }
    }

    protected String determineRootDir(String location) {
        int prefixEnd = location.indexOf(58) + 1;
        int rootDirEnd = location.length();
        while (rootDirEnd > prefixEnd && this.getPathMatcher().isPattern(location.substring(prefixEnd, rootDirEnd))) {
            rootDirEnd = location.lastIndexOf(47, rootDirEnd - 2) + 1;
        }
        if (rootDirEnd == 0) {
            rootDirEnd = prefixEnd;
        }
        return location.substring(0, rootDirEnd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<Resource> doFindPathMatchingJarResources(JarResource rootDirResource, String subPattern) throws IOException {
        URL rootDirURL = rootDirResource.getLocation();
        JarURLConnection jarCon = (JarURLConnection)rootDirURL.openConnection();
        ResourceUtils.useCachesIfNecessary(jarCon);
        JarEntry jarEntry = jarCon.getJarEntry();
        String rootEntryPath = jarEntry != null ? jarEntry.getName() : "";
        boolean closeJarFile = !jarCon.getUseCaches();
        JarFile jarFile = rootDirResource.getJarFile();
        try {
            if (log.isTraceEnabled()) {
                String jarFileUrl = jarCon.getJarFileURL().toExternalForm();
                log.trace("Looking for matching resources in jar file [{}]", (Object)jarFileUrl);
            }
            if (!"".equals(rootEntryPath) && !rootEntryPath.endsWith("/")) {
                rootEntryPath = rootEntryPath.concat("/");
            }
            PathMatcher pathMatcher = this.getPathMatcher();
            LinkedHashSet<Resource> result = new LinkedHashSet<Resource>(8);
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                String relativePath;
                String entryPath = entries.nextElement().getName();
                if (!entryPath.startsWith(rootEntryPath) || !pathMatcher.match(subPattern, relativePath = entryPath.substring(rootEntryPath.length()))) continue;
                result.add(rootDirResource.createRelative(relativePath));
            }
            LinkedHashSet<Resource> linkedHashSet = result;
            return linkedHashSet;
        }
        finally {
            if (closeJarFile) {
                jarFile.close();
            }
        }
    }

    protected Set<Resource> doFindPathMatchingFileResources(Resource rootDirResource, String subPattern) throws IOException {
        try {
            File rootDir = rootDirResource.getFile().getAbsoluteFile();
            return this.doFindMatchingFileSystemResources(rootDir, subPattern);
        }
        catch (FileNotFoundException ex) {
            log.error("Cannot search for matching files underneath {} in the file system: {}", rootDirResource, ex.toString(), ex);
            return Collections.emptySet();
        }
        catch (Exception ex) {
            log.error("Failed to resolve {} in the file system: {}", rootDirResource, ex.toString(), ex);
            return Collections.emptySet();
        }
    }

    protected Set<Resource> doFindMatchingFileSystemResources(File rootDir, String subPattern) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace("Looking for matching resources in directory tree [{}]", (Object)rootDir.getPath());
        }
        Set<File> matchingFiles = this.retrieveMatchingFiles(rootDir, subPattern);
        LinkedHashSet<Resource> result = new LinkedHashSet<Resource>(matchingFiles.size());
        for (File file : matchingFiles) {
            result.add(new FileBasedResource(file));
        }
        return result;
    }

    protected Set<File> retrieveMatchingFiles(File rootDir, String pattern) throws IOException {
        if (!rootDir.exists()) {
            if (log.isDebugEnabled()) {
                log.debug("Skipping [{}] because it does not exist", (Object)rootDir.getAbsolutePath());
            }
            return Collections.emptySet();
        }
        if (!rootDir.isDirectory()) {
            if (log.isInfoEnabled()) {
                log.info("Skipping [{}] because it does not denote a directory", (Object)rootDir.getAbsolutePath());
            }
            return Collections.emptySet();
        }
        if (!rootDir.canRead()) {
            if (log.isInfoEnabled()) {
                log.info("Skipping search for matching files underneath directory [{}] because the application is not allowed to read the directory", (Object)rootDir.getAbsolutePath());
            }
            return Collections.emptySet();
        }
        String fullPattern = StringUtils.replace(rootDir.getAbsolutePath(), File.separator, "/");
        if (!pattern.startsWith("/")) {
            fullPattern = fullPattern + '/';
        }
        fullPattern = fullPattern + StringUtils.replace(pattern, File.separator, "/");
        LinkedHashSet<File> result = new LinkedHashSet<File>(8);
        this.doRetrieveMatchingFiles(fullPattern, rootDir, result);
        return result;
    }

    protected void doRetrieveMatchingFiles(String fullPattern, File dir, Set<File> result) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace("Searching directory [{}] for files matching pattern [{}]", (Object)dir.getAbsolutePath(), (Object)fullPattern);
        }
        PathMatcher pathMatcher = this.getPathMatcher();
        for (File content : this.listDirectory(dir)) {
            String currPath = StringUtils.replace(content.getAbsolutePath(), File.separator, "/");
            if (content.isDirectory() && pathMatcher.matchStart(fullPattern, currPath.concat("/"))) {
                if (content.canRead()) {
                    this.doRetrieveMatchingFiles(fullPattern, content, result);
                } else if (log.isDebugEnabled()) {
                    log.debug("Skipping subdirectory [{}] because the application is not allowed to read the directory", (Object)dir.getAbsolutePath());
                }
            }
            if (!pathMatcher.match(fullPattern, currPath)) continue;
            result.add(content);
        }
    }

    protected File[] listDirectory(File dir) {
        File[] files = dir.listFiles();
        if (files == null) {
            if (log.isInfoEnabled()) {
                log.info("Could not retrieve contents of directory [{}]", (Object)dir.getAbsolutePath());
            }
            return new File[0];
        }
        Arrays.sort(files, Comparator.comparing(File::getName));
        return files;
    }
}

