/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.io;

import cn.taketoday.context.Constant;
import cn.taketoday.context.io.AbstractResource;
import cn.taketoday.context.io.Resource;
import cn.taketoday.context.io.ResourceFilter;
import cn.taketoday.context.io.WritableResource;
import cn.taketoday.context.utils.ResourceUtils;
import cn.taketoday.context.utils.StringUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;

public class FileBasedResource
extends AbstractResource
implements WritableResource {
    private final File file;
    private final String path;
    private final Path filePath;

    public FileBasedResource(String path) {
        this.path = StringUtils.cleanPath(path);
        this.file = new File(this.path);
        this.filePath = this.file.toPath();
    }

    public FileBasedResource(File file) {
        this.file = file;
        this.filePath = file.toPath();
        this.path = StringUtils.cleanPath(file.getPath());
    }

    public FileBasedResource(Path filePath) {
        this.file = null;
        this.filePath = filePath;
        this.path = StringUtils.cleanPath(filePath.toString());
    }

    public final String getPath() {
        return this.path;
    }

    @Override
    public boolean exists() {
        return this.file != null ? this.file.exists() : Files.exists(this.filePath, new LinkOption[0]);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        try {
            return Files.newInputStream(this.filePath, new OpenOption[0]);
        }
        catch (NoSuchFileException ex) {
            throw new FileNotFoundException(ex.getMessage());
        }
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return Files.newOutputStream(this.filePath, new OpenOption[0]);
    }

    @Override
    public URL getLocation() throws IOException {
        return this.file != null ? this.file.toURI().toURL() : this.filePath.toUri().toURL();
    }

    @Override
    public File getFile() {
        return this.file != null ? this.file : this.filePath.toFile();
    }

    @Override
    public long contentLength() throws IOException {
        if (this.file != null) {
            long length = this.file.length();
            if (length == 0L && !this.file.exists()) {
                throw new FileNotFoundException(this.getName() + " cannot be resolved its content length");
            }
            return length;
        }
        try {
            return Files.size(this.filePath);
        }
        catch (NoSuchFileException ex) {
            throw new FileNotFoundException(ex.getMessage());
        }
    }

    @Override
    public long lastModified() throws IOException {
        if (this.file != null) {
            return super.lastModified();
        }
        try {
            return Files.getLastModifiedTime(this.filePath, new LinkOption[0]).toMillis();
        }
        catch (NoSuchFileException ex) {
            throw new FileNotFoundException(ex.getMessage());
        }
    }

    @Override
    public Resource createRelative(String relativePath) throws IOException {
        String pathToUse = ResourceUtils.getRelativePath(this.path, relativePath);
        return this.file != null ? new FileBasedResource(pathToUse) : new FileBasedResource(this.filePath.getFileSystem().getPath(pathToUse, new String[0]).normalize());
    }

    @Override
    public Resource[] list(ResourceFilter filter) throws IOException {
        String[] names = this.list();
        if (StringUtils.isArrayEmpty(names)) {
            return Constant.EMPTY_RESOURCE_ARRAY;
        }
        String path = this.path;
        ArrayList<FileBasedResource> resources = new ArrayList<FileBasedResource>();
        for (String name : names) {
            FileBasedResource resource = new FileBasedResource(new File(path, name));
            if (filter != null && !filter.accept(resource)) continue;
            resources.add(resource);
        }
        if (resources.isEmpty()) {
            return Constant.EMPTY_RESOURCE_ARRAY;
        }
        return resources.toArray(new Resource[resources.size()]);
    }

    @Override
    public String getName() {
        Path fileName;
        if (this.file != null) {
            return this.file.getName();
        }
        if (this.filePath != null && (fileName = this.filePath.getFileName()) != null) {
            return fileName.toString();
        }
        return new File(this.path).getName();
    }

    @Override
    public ReadableByteChannel readableChannel() throws IOException {
        try {
            return FileChannel.open(this.filePath, StandardOpenOption.READ);
        }
        catch (NoSuchFileException ex) {
            throw new FileNotFoundException(ex.getMessage());
        }
    }

    @Override
    public WritableByteChannel writableChannel() throws IOException {
        return FileChannel.open(this.filePath, StandardOpenOption.WRITE);
    }

    @Override
    public boolean isReadable() {
        return this.file != null ? this.file.canRead() && !this.file.isDirectory() : Files.isReadable(this.filePath) && !Files.isDirectory(this.filePath, new LinkOption[0]);
    }

    @Override
    public boolean equals(Object other) {
        return this == other || other instanceof FileBasedResource && this.path.equals(((FileBasedResource)other).path);
    }

    @Override
    public int hashCode() {
        return this.path.hashCode();
    }

    @Override
    public String toString() {
        return "FileBasedResource: ".concat(this.path);
    }
}

