/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.factory;

import cn.taketoday.context.factory.AbstractBeanFactory;
import cn.taketoday.context.factory.BeanDefinition;
import cn.taketoday.context.factory.FactoryBean;
import cn.taketoday.context.factory.FactoryBeanDefinition;
import cn.taketoday.context.utils.Assert;
import java.util.function.Supplier;

public class FactoryBeanSupplier<T>
implements Supplier<FactoryBean<T>> {
    private FactoryBean<T> factoryBean;
    private final BeanDefinition factoryDef;
    private final AbstractBeanFactory beanFactory;

    public FactoryBeanSupplier(BeanDefinition factoryDef, AbstractBeanFactory beanFactory) {
        Assert.notNull((Object)beanFactory, "beanFactory must not be null");
        Assert.notNull((Object)factoryDef, "factory BeanDefinition must not be null");
        Assert.isAssignable(FactoryBean.class, factoryDef.getBeanClass(), "Target bean class must be 'cn.taketoday.context.factory.FactoryBean'");
        this.beanFactory = beanFactory;
        this.factoryDef = factoryDef instanceof FactoryBeanDefinition ? ((FactoryBeanDefinition)factoryDef).getFactoryDefinition() : factoryDef;
    }

    @Override
    public FactoryBean<T> get() {
        FactoryBean<T> factoryBean = this.factoryBean;
        if (factoryBean == null) {
            this.factoryBean = this.beanFactory.getFactoryBean(this.factoryDef);
            return this.factoryBean;
        }
        return factoryBean;
    }
}

